﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Consultative;
using Base;

public partial class admin_Consultative_ConsultativeManage : BasePage
{
    private int pageSize = 12;//这里设置分页尺寸


    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "B1");
        if (!IsPostBack)
        {
            Bind();
            dropTypeInfo();
        }
    }


    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
        string strWhere = "1=1";
        string labletype = "";
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        PageNo1.Table = "W_ConsultativeType as b  Right  JOIN W_Consultative as a  ON a.TypeID = b.ID ";
        PageNo1.FldName = "a.AddDate";
        PageNo1.StrGetFields = "a.*,b.Name,(select count(*) from W_ConsultativeRestore as c where c.ConsultativeID=a.ID)as time";
        PageNo1.PageSize = pageSize;
        if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdConsultative.DataSource = dt.DefaultView;
            grdConsultative.DataBind();
        }
        else
        {
            if (Request.QueryString["TypeID"] != null && Request.QueryString["TypeID"] != "")
            {
                labletype = Base.GetRequest.Filter(Request.QueryString["TypeID"].ToString());
                strWhere += " and TypeID=" + labletype;
            }
            else
            {
                string keyword = Base.GetRequest.Filter(txtKeyWord.Text.Trim());
                labletype = dropType.SelectedValue;
                if (keyword != "")
                    strWhere += " and title like '%" + keyword + "%'";
                if (labletype != "")
                    strWhere += " and TypeID=" + labletype + "";
            }
            PageNo1.Pageindex = 1;
            PageNo1.Where = strWhere;
            Session["strWhere"] = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdConsultative.DataSource = dt.DefaultView;
            grdConsultative.DataBind();
        }
    }

    ///<summary>
    /// 行业资讯类别绑定
    ///</summary>
    private void dropTypeInfo()
    {
        dropType.Items.Add(new ListItem("--+请选择所属类别+--", ""));
        IConsultativeType RCon = new RConsultativeType();
        DataTable dt = RCon.GetDataTable();

        if (dt.Rows.Count != 0)
        {
            foreach (DataRow dataRow in dt.Rows)
            {
                dropType.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));
            }
        }
    }


    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }


    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= grdConsultative.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdConsultative.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int id = Convert.ToInt32(grdConsultative.DataKeys[i].Value);
                IConsultative RUser = new RConsultative();
                RUser.Delete(id);
            }
        }
        Bind();
    }


    protected void btnsubmit_Click(object sender, EventArgs e)
    {
        string strWhere = "1=1";
        string keyword = txtKeyWord.Text.Trim();
        string labletype = dropType.SelectedValue;
        if (keyword != "")
            strWhere += " and title like '%" + Base.GetRequest.Filter(keyword) + "%'";
        if (labletype != "")
            strWhere += " and TypeID=" + Base.GetRequest.Filter(labletype);

        Session["strWhere"] = strWhere;
        string strURl2 = Request.RawUrl;
        strURl2 = strURl2.Substring(0, strURl2.IndexOf(".aspx")) + ".aspx?page=1";
        Response.Redirect(strURl2);
        Response.End();
    }


    protected void grdConsultative_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        grdConsultative.PageIndex = e.NewPageIndex;
        Bind();
    }


    protected void lnkdelete_Command(object sender, CommandEventArgs e)
    {
        IConsultative rs = new RConsultative();
        int id = int.Parse(e.CommandArgument.ToString());
        int m = rs.Delete(id);
        Bind();
    }


    protected void grdConsultative_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");

            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this);");

        }

    }

    /// <summary>
    /// 处理标题
    /// </summary>
    /// <param name="Title"></param>
    /// <param name="IsTop"></param>
    /// <param name="IsRecommend"></param>
    /// <param name="IsHotspot"></param>
    /// <param name="Picture"></param>
    /// <returns></returns>
    public string GetNewTitle(string Title, string strID, string IsTop, string IsRecommend, string IsHotspot, string Picture)
    {
        string Restr = "<a href=\"/News/Detail.aspx?id=" + strID + "\" target=\"blank\">" + Title + "</a>";
        if (IsTop.Equals("True"))
        {
            Restr += "<font color=\"red\"> 顶</font>";
        }
        if (IsRecommend.Equals("True"))
        {
            Restr += "<font color=\"green\"> 荐</font>";
        }
        if (IsHotspot.Equals("True"))
        {
            Restr += "<font color=\"Purple\"> 幻</font>";
        }
        if (Picture != "")
        {
            Restr += "<font color=\"red\"> 图</font>";
        }
        return Restr;
    }

}
