﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Consultative;

public partial class admin_Consultative_ConsultativeRestoreDetail : BasePage
{
    protected string Title = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        if (Request.QueryString["ID"] != null && Request.QueryString["ID"] != "")
        {
            int id = int.Parse(Request.QueryString["ID"].ToString());
            string strWhere = "W_Consultative.ID=" + id;
            int PageIndex = 0;

            string table = "W_ConsultativeRestore inner join W_Consultative  on W_ConsultativeRestore.ConsultativeID=W_Consultative.ID";
            string select = "W_ConsultativeRestore.ID,W_ConsultativeRestore.UserName,W_ConsultativeRestore.AddDate,W_ConsultativeRestore.Detail,W_ConsultativeRestore.Shield,W_Consultative.Title";
            if (HttpContext.Current.Request.QueryString["page"] != null)
                PageIndex = Convert.ToInt32(Request.QueryString["Page"].ToString());
            if (PageIndex <= 0) PageIndex = 1;

            DataTable dt = PageList.GetDataTable(strWhere, table, 1, "W_ConsultativeRestore.AddDate", select, 10, PageIndex, 0);
            if (dt.Rows.Count != 0)
                Title = dt.Rows[0]["Title"].ToString();
            gvRestore.DataSource = dt.DefaultView;
            gvRestore.DataBind();
            this.lblPagination.Text = PageList.GoToPager(PageIndex, 10, "ConsultativeRestoreDetail.aspx?page", strWhere, table);
        }
    }
    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }
    protected void lbtnDelete_Command(object sender, CommandEventArgs e)
    {
        int id = int.Parse(e.CommandArgument.ToString());
        IConsultativeRestore RCon = new RConsultativeRestore();
        RCon.Delete(id);
        Bind();
    }
    protected void lbtnShield_Command1(object sender, CommandEventArgs e)
    {
        TConsultativeRestore TCon = new TConsultativeRestore();
        string Content = e.CommandArgument.ToString();
        int index = Content.IndexOf("|");
        if (index < -1 || index + 1 > Content.Length)
            return;

        TCon.ID = int.Parse(Content.Substring(0, index));
        TCon.Shield = Convert.ToBoolean(Content.Substring(index + 1));
        IConsultativeRestore RCon = new RConsultativeRestore();
        RCon.UpdateShield(TCon);
        Bind();
    }
    protected void gvRestore_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {

            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");

            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this);");

        }      
    }
}
