﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Consultative;

public partial class admin_Consultative_ConsultativeRestoreList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        string strWhere = "";
        int PageIndex = 0;

        string table = "W_ConsultativeRestore left join W_Consultative  on W_ConsultativeRestore.ConsultativeID=W_Consultative.ID";
        string select = "W_ConsultativeRestore.ID,W_ConsultativeRestore.UserName,W_ConsultativeRestore.AddDate,W_ConsultativeRestore.Detail,W_ConsultativeRestore.Shield,W_Consultative.Title,W_Consultative.ID as ConsultativeID";
        if (HttpContext.Current.Request.QueryString["page"] != null)
            PageIndex = Convert.ToInt32(Request.QueryString["Page"].ToString());
        if (PageIndex <= 0) PageIndex = 1;

        DataTable dt = PageList.GetDataTable(strWhere, table, 1, "W_ConsultativeRestore.AddDate", select, 10, PageIndex, 0);
        grdRestore.DataSource = dt.DefaultView;
        grdRestore.DataBind();
        this.lblPagination.Text = PageList.GoToPager(PageIndex, 10, "ConsultativeRestoreList.aspx?page", strWhere, table);
    }
    public string GetShortDate(string StrDate)
    {
        if (StrDate != string.Empty)
            return Convert.ToDateTime(StrDate).ToShortDateString();
        else
            return string.Empty;
    }
    protected void lbtnShield_Command(object sender, CommandEventArgs e)
    {
        TConsultativeRestore TCon = new TConsultativeRestore();
        string Content = e.CommandArgument.ToString();
        int index = Content.IndexOf("|");
        if (index < -1 || index + 1 > Content.Length)
            return;

        TCon.ID = int.Parse(Content.Substring(0, index));
        TCon.Shield = Convert.ToBoolean(Content.Substring(index + 1));
        IConsultativeRestore RCon = new RConsultativeRestore();
        RCon.UpdateShield(TCon);
        Bind();
    }

    protected void grdRestore_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = int.Parse(grdRestore.DataKeys[e.RowIndex].Value.ToString());
        IConsultativeRestore RCon = new RConsultativeRestore();
        RCon.Delete(id);
        Bind();
    }
}
