﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Consultative;
using Base;
using SqlOperate;

public partial class admin_Consultative_ConsultativeTypeManage : Base.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "B1");
        if (!IsPostBack)
        {
            Bind();
            TypeBind();
        }
    }
    int ParentID = 0;
    static int Iid = 0;
    private void Bind()
    {
        if (Request["ParentId"] == null)
        {
            btnMove.Attributes.Add("onclick", "javascript:return confirm('转移此类别,将连同子类别一起转移,你可以先转移子类别.确定一起转移吗?')");
        }
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('删除这些类别,将连同子类别、类别信息一起删除,你可以先转移这些类别的信息.确定都删除吗?')");
       
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        string strWhere = "1=1";
        PageNo1.Strurl = strURl;
        PageNo1.FldName = "b.ID";
        PageNo1.Table = "W_ConsultativeType as b ";
        PageNo1.StrGetFields = "b.ID,b.Name,b.ParentID,(select count(*) from W_ConsultativeType where ParentID=b.ID) as time";
        PageNo1.PageSize = 12; 
        if (Request.QueryString["ParentId"] != null && Request.QueryString["ParentId"] != "")
        {
            ParentID = int.Parse(Request.QueryString["ParentId"]);
        }
        strWhere += " AND ParentID=" + ParentID;
        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
                return;
            }
            else
                lblMessage.Visible = false;
            gvConsultativeType.DataSource = dt.DefaultView;
            gvConsultativeType.DataBind();
        }
        else {
            PageNo1.Where = strWhere;
            PageNo1.Pageindex = 1;
            Session["strWhere"] = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
                return;
            }
            else
                lblMessage.Visible = false;
            gvConsultativeType.DataSource = dt.DefaultView;
            gvConsultativeType.DataBind();
        }


    }
    private void TypeBind()
    {
        ddlMove.Items.Add(new ListItem("--+请选择所属类别+--", "0"));
        IConsultativeType RCon = new RConsultativeType();
        DataTable d = RCon.GetDataTable();
        if (d.Rows.Count != 0)
        {
            foreach (DataRow dataRow in d.Rows)
            {
                ddlMove.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));
            }
        }
    } 
    protected void gvConsultativeType_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        IConsultativeType rs = new RConsultativeType();
        int id = int.Parse(gvConsultativeType.DataKeys[e.RowIndex]["ID"].ToString());
        int m = rs.Delete(id, 0, 0, 0);
        string strTypeID = gvConsultativeType.DataKeys[e.RowIndex]["ID"].ToString();
        IConsultative ICtive = new RConsultative();
        ICtive.DeleteByTypeID(strTypeID);
        Bind();
    }   
    protected void gvConsultativeType_RowCreated(object sender, GridViewRowEventArgs e)
    {
        if (Request["ParentId"] != null && Request["ParentId"] != "")
        {
            HyperLink hlkName = e.Row.Cells[1].FindControl("TypeName") as HyperLink;
            Label lbl = e.Row.Cells[1].FindControl("lblName") as Label;
            if (hlkName != null)
            {
                hlkName.Visible = false;
                lbl.Visible = true;
            }
            HyperLink hlkAdd = e.Row.Cells[2].FindControl("hlkAdd") as HyperLink;
            if (hlkAdd != null)
            {
                hlkAdd.Enabled = false;
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        plConsultativeType.Visible = false;
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            if (txtName.Text == string.Empty)
            {
                Response.Write("<script>alert('信息类别不能为空！')</script>");
                return;
            }
            int ParentId = 0;
            if (Request["ParentId"] != null && Request["ParentId"] != "")
            {
                ParentId = int.Parse(Request["ParentId"]);
            }
            TConsultativeType TCon = new TConsultativeType();
            TCon.Name = txtName.Text;
            TCon.ParentID = ParentId;
            IConsultativeType RCon = new RConsultativeType();
            RCon.Insert(TCon);
            this.txtName.Text = "";
            if (Request["ParentId"] != null && Request["ParentId"] != "")
            {
                ShowMessage("子类别添加成功！", "Consultative/ConsultativeTypeManage.aspx?ParentID=" + Request["ParentId"]);
            }
            ShowMessage("信息类别添加成功！", "Consultative/ConsultativeTypeManage.aspx");
            Bind();
        }
        catch (Exception ex)
        {
            this.txtName.Text = "";
            ShowMessage("添加失败！", "Consultative/ConsultativeTypeManage.aspx");
        }
    }
    protected void Lbtn_Add_Click(object sender, EventArgs e)
    {
        plConsultativeType.Visible = true;
        plMove.Visible = false;
    }
    protected void gvConsultativeType_RowEditing(object sender, GridViewEditEventArgs e)
    {
        gvConsultativeType.EditIndex = e.NewEditIndex;
        Bind();
    }
    protected void gvConsultativeType_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        int id = int.Parse(gvConsultativeType.DataKeys[e.RowIndex].Value.ToString());
        string name = ((TextBox)gvConsultativeType.Rows[e.RowIndex].FindControl("txtName")).Text;
        TConsultativeType TCon = new TConsultativeType();
        TCon.ID = id;
        TCon.Name = name;
        IConsultativeType RCon = new RConsultativeType();
        RCon.Update(TCon);
        gvConsultativeType.EditIndex = -1;
        Bind();
    }
    protected void gvConsultativeType_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        gvConsultativeType.EditIndex = -1;
        Bind();
    }
    protected void ButJS_Click(object sender, EventArgs e)
    {
        Bind();
    }

    protected void lbtnBank_Click(object sender, EventArgs e)
    {
        Response.Redirect("ConsultativeTypeManage.aspx");
    }
    protected void lbtnMove_Click(object sender, EventArgs e)
    {
        plMove.Visible = true;
    }
    protected void btnMove_Click(object sender, EventArgs e)
    {
        if (Request["ParentId"] != null && Request["ParentId"] != "")
        {
            if (ddlMove.SelectedValue == "0")
            {
                ShowMessage("请选择所属类别");
                return;
            }
            IConsultativeType Rcon = new RConsultativeType();
            int k = Rcon.Delete(Iid, int.Parse(ddlMove.SelectedValue), 1, int.Parse(Request["ParentId"].ToString()));
            Bind();
            plMove.Visible = false;
        }
        else
        {

            if (ddlMove.SelectedValue == "0")
            {
                ShowMessage("请选择所属类别");
                return;
            }
            IConsultativeType Rcon = new RConsultativeType();
            int k = Rcon.Delete(Iid, int.Parse(ddlMove.SelectedValue), 1, 0);
            Bind();
            plMove.Visible = false;

        }
    }

    protected void lbtnMove_Command(object sender, CommandEventArgs e)
    {
        plConsultativeType.Visible = false;
        Iid = int.Parse(e.CommandArgument.ToString());
    }
    protected void btnBank_Click(object sender, EventArgs e)
    {
        plMove.Visible = false;
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
		try
		{
			string strTypeID = "";
        for (int i = 0; i <= gvConsultativeType.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)gvConsultativeType.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int id = Convert.ToInt32(gvConsultativeType.DataKeys[i].Value);
                strTypeID += gvConsultativeType.DataKeys[i].Value.ToString() + ",";
                IConsultativeType RCon = new RConsultativeType();
                RCon.Delete(id, 0, 0, 0);
            }
        }
        strTypeID = strTypeID.TrimEnd(new char[] { ',' });
        IConsultative ICtive = new RConsultative();
        ICtive.DeleteByTypeID(strTypeID);
        Bind();
		}
		catch (Exception ex)
		{
		}
        
    }

    public bool IsCount(string time)
    {
        if (!time.Equals("0"))
            return true;

        else
            return false;
    }
    protected void gvConsultativeType_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
        }
    }   
}
