﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Certificate.aspx.cs" Inherits="admin_Corporation_Certificate_Certificate" %>

<%@ Register Src="../../../Control/PageNo.ascx" TagName="PageNo" TagPrefix="uc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>会员证书管理</title>
    <link rel="stylesheet" href="../../skin/Style.css" type="text/css" />

    <script type="text/javascript" src="../../../js/jquery.js"></script>

</head>
<body>
    <form id="form1" runat="server">
        <div class="itemtitle">
            <h3>
                证书搜索</h3>
        </div>
        <div class="itemtitle_tect">
            <p>
                公司名称：<asp:TextBox ID="txtCompany" runat="server"></asp:TextBox>&nbsp;证书名称：<asp:TextBox
                    ID="txtCertificateName" runat="server"></asp:TextBox><asp:Button ID="btnSearch" runat="server"
                        OnClick="btnSearch_Click" Text="立即查找" CssClass="i_button" />
            </p>
        </div>
        <div class="clr">
        </div>
        <div class="talbe_border">
            <asp:GridView ID="grdCertificate" runat="server" AutoGenerateColumns="False" CellPadding="0"
                GridLines="None" DataKeyNames="ID" Font-Bold="False" Font-Overline="False" AllowPaging="False"
                CssClass="talbe_list" OnRowDataBound="grdCertificate_RowDataBound" OnRowDeleting="grdCertificate_RowDeleting">
                <Columns>
                    <asp:TemplateField>
                        <ItemTemplate>
                            <asp:CheckBox ID="CheckBox1" runat="server" />
                        </ItemTemplate>
                        <HeaderStyle CssClass="th20 tou" />
                        <ItemStyle CssClass="nolet" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="证书图片">
                        <ItemTemplate>
                            <asp:Image ID="imgUrl" runat="server" ImageUrl='<%# GetNewUrl(DataBinder.Eval(Container.DataItem, "Url").ToString())%>' Width="80px"
                                Height="60px" />
                        </ItemTemplate>
                        <HeaderStyle CssClass="th80" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="Name" HeaderText="证书名称"></asp:BoundField>
                    <asp:BoundField DataField="CompanyName" HeaderText="公司名称">
                        <HeaderStyle CssClass="th80" />
                    </asp:BoundField>
                    <asp:BoundField DataField="Organization" HeaderText="发证机构"></asp:BoundField>
                    <asp:TemplateField HeaderText="发证日期">
                        <ItemTemplate>
                           <%# GetShortDate(DataBinder.Eval(Container.DataItem, "LicenceDate").ToString())%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="证书有效期">
                        <ItemTemplate>
                           <%# GetShortDate(DataBinder.Eval(Container.DataItem, "ExpiryDate").ToString())%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <a href='CertificateEdit.aspx?ID=<%# DataBinder.Eval(Container.DataItem, "ID")%>&UserID=<%# Eval("UserID") %>'>
                                编辑 </a>
                            <asp:LinkButton ID="lbtnDelete" runat="server" CommandName="delete">删除</asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
                <HeaderStyle CssClass="header" />
                <AlternatingRowStyle BackColor="White" />
            </asp:GridView>
            <asp:Label ID="lblMessage" runat="server" Text="Label" Visible="False"></asp:Label>
            <div class="Paging">
			 <p><uc1:PageNo ID="PageNo1" runat="server" /></p>
                <input id="CheckBox2" name="CheckBox2" type="checkbox" onclick="SelectAll();" />全选
                <asp:Button ID="btnDelete" runat="server" Text="批量删除" OnClick="btnDelete_Click" CssClass="i_button" />
            </div>
        </div>
    </form>
</body>
</html>
