﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Certificate;
using Base;

public partial class admin_Corporation_Certificate_Certificate : BasePage
{
    private int pageSize = 12;//这里设置分页尺寸

    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("User", "A1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    ///**************************************************
    /// <summary>
    /// depiction：实现对公司证书的绑定
    /// </summary>
    /// <param name="<参数名称>">
    /// <参数说明></param>
    /// <returns>
    ///  通过调用GetDataTable实现
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Writer：作者中文名
    ///Create Date：<方法创建日期，格式：YYYY-MM-DD>
    ///**************************************************
    #region 绑定数据
    public void Bind()
    {
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
        string strWhere = "1=1";
        string CompanyName = txtCompany.Text.Trim();
        string CertificateName = txtCertificateName.Text.Trim();
        if (CompanyName != "")
            strWhere += " and CompanyName like '%" + CompanyName + "%'";
        if (CertificateName != "")
            strWhere += " and Name like '%" + CertificateName + "%'";
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        if (Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            PageNo1.PageSize = 12;
            if (Session["strWhere"] != null)
            {
                PageNo1.Where = Session["strWhere"].ToString();
            }
            else
            {
                PageNo1.Where = "1=1";
            }
            PageNo1.Table = "C_Certificate INNER JOIN U_UserInfo ON C_Certificate.UserID=U_UserInfo.UserID ";
            PageNo1.FldName = "AddDate";
            PageNo1.StrGetFields = "C_Certificate.*,U_UserInfo.CompanyName";
            DataTable table = PageNo1.BindViewDesc();
            grdCertificate.DataSource = table.DefaultView;
            grdCertificate.DataBind();
        }
        else
        {
            PageNo1.Pageindex = 1;
            PageNo1.PageSize = 12;
            PageNo1.Where = "1=1";
            PageNo1.Table = "C_Certificate INNER JOIN U_UserInfo ON C_Certificate.UserID=U_UserInfo.UserID ";
            PageNo1.FldName = "AddDate";
            PageNo1.StrGetFields = "C_Certificate.*,U_UserInfo.CompanyName";
            DataTable table = PageNo1.BindViewDesc();
            grdCertificate.DataSource = table.DefaultView;
            grdCertificate.DataBind();
        }
    }
    #endregion
    public string GetShortDate(string dateStr)
    {
        if (dateStr != String.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= grdCertificate.Rows.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)grdCertificate.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {

                int id = Convert.ToInt32(grdCertificate.DataKeys[i].Value);
                ICertificate RSystem = new RCertificate();
                int m = RSystem.Delete(id);
            }
        }
        Bind();
    }
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        string strWhere = "1=1";
        string CompanyName = Base.GetRequest.Filter(txtCompany.Text.Trim());
        string CertificateName =Base.GetRequest.Filter(txtCertificateName.Text.Trim());
        if (CompanyName != "")
            strWhere += " and CompanyName like '%" + CompanyName + "%'";
        if (CertificateName != "")
            strWhere += " and Name like '%" + CertificateName + "%'";
        Session["strWhere"] = strWhere;
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx?page=1";
        Response.Redirect(strURl);
        Response.End();
    }

    protected void grdCertificate_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
        }
    }
    protected void grdCertificate_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = Convert.ToInt32(grdCertificate.DataKeys[e.RowIndex].Value);
        ICertificate RSystem = new RCertificate();
        int m = RSystem.Delete(id);
        Bind();
    }

    public string GetNewUrl(string Url)
    {
        return ProcessImageUrl(Url);
    }
}
