﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Certificate;
using Base;

public partial class admin_Corporation_Certificate_CertificateEdit : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("User", "A1");
        if (!IsPostBack)
        {
            bind();
        }
        txtCorp.Enabled = false;

    }
    /// <summary>
    /// 公司证书的绑定
    /// </summary>
    public void bind()
    {
        if (Request.QueryString["ID"] != null && Request.QueryString["ID"] != "")
        {
            int id = Convert.ToInt32(Request.QueryString["ID"].ToString());
            if (Request.QueryString["UserID"] != null && Request.QueryString["UserID"] != "")
                this.HiddUserID.Value = Request.QueryString["UserID"].ToString();
            ICertificate RCerti = new RCertificate();
            TCertificate TCerti = RCerti.GateItem(id);
            txtCorp.Text = TCerti.CompanyName;
            txtName.Text = TCerti.Name;
            ImgUrl.Src = ProcessImageUrl(TCerti.URL);
            ImgUrl1.Value = ProcessImageUrl(TCerti.URL);
            txtOrganization.Text = TCerti.Organization;
            txtLicenceDate.Text = TCerti.LicenceDate.ToShortDateString();
            txtExpiryDate.Text = TCerti.ExpiryDate.ToShortDateString();
        }

    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null && Request.QueryString["ID"] != "")
        {
            try
            {
                int id = Convert.ToInt32(Request.QueryString["ID"].ToString());
                TCertificate TCerti = new TCertificate();
                TCerti.ID = id;
                TCerti.UserID = Convert.ToInt32(HiddUserID.Value);
                TCerti.Name = txtName.Text;
                TCerti.URL = ImgUrl1.Value;
                TCerti.Organization = txtOrganization.Text;
                TCerti.LicenceDate = Convert.ToDateTime(txtLicenceDate.Text);
                TCerti.ExpiryDate = Convert.ToDateTime(txtExpiryDate.Text);
                ICertificate RCerti = new RCertificate();
                RCerti.Update(TCerti);
                ShowMessage("证书修改成功！", "Corp/Certificate/Certificate.aspx");
            }
            catch (Exception ex)
            {

                ShowMessage("证书修改失败！", "Corp/Certificate/Certificate.aspx");
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("Certificate.aspx");
    }
}
