﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Corporation.Link;
using System.IO;

public partial class admin_Corp_Link_LinkEint : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("User", "C1");
        if (!IsPostBack)
        {
            Bind();
        }
    }

    private void Bind()
    {

        if (Request.QueryString["ID"] != null)
        {
            if (Request.QueryString["UserID"] != null)
                this.HiddUserID.Value = Request.QueryString["UserID"].ToString();
            int id = int.Parse(Request.QueryString["ID"].ToString());
            RLink RLink = new RLink();
            TLink TLink = RLink.GateItem(id);
            txtName.Text = TLink.Name;
            txtUrl.Text = TLink.Url;
            ImgUrl.Src = ProcessImageUrl(TLink.Logo);
            try
            {
                if (!File.Exists(Server.MapPath(this.ImgUrl1.Value)))
                {
                    ImgUrl1.Value = ImgUrl.Src;

                }

            }
            catch (Exception er) { ImgUrl1.Value = ImgUrl.Src; }

        }

    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null)
        {
            try
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                ILink RLink = new RLink();
                TLink TLink = new TLink();
                TLink.ID = id;
                TLink.Name = txtName.Text.Trim();
                TLink.Url = txtUrl.Text;
                if (!File.Exists(Server.MapPath(this.ImgUrl1.Value)))
                {
                    TLink.Logo = ProcessImageUrl(this.ImgUrl.Src.ToString());
                }
                else
                {
                    TLink.Logo = ProcessImageUrl(this.ImgUrl1.Value.ToString());
                }
                RLink.Update(TLink);
                ShowMessage("友情链接修改成功！","Corp/Link/LinkList.aspx");
            }
            catch (Exception ex)
            {

                ShowMessage("友情链接修改失败！", "Corp/Link/LinkList.aspx");
            }
        }
        else
        {
            try
            {
                TLink TLink = new TLink();
                int userid = int.Parse(GetCookie("UserID").ToString());
                TLink.UserID = userid;
                TLink.Name = txtName.Text.Trim();
                TLink.Url = txtUrl.Text;
                TLink.Logo = ProcessImageUrl(ImgUrl1.Value);
                ILink RLink = new RLink();
                RLink.Insert(TLink);
                ShowMessage("友情链接添加成功！", "LinkList.aspx");
            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }

    }
    protected void Back_Click(object sender, EventArgs e)
    {
        Response.Write("<script language=javascript>window.location.href='LinkList.aspx'</script>");
    }

}
