﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Message;

public partial class admin_Corp_Message_MessageDetail : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Bind();
        }
    }

    private void Bind()
    {
        int id = 0;
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
        if (Request.QueryString["ID"] != null)
            id = int.Parse(Request.QueryString["ID"].ToString());

        //定义IUserInfo接口
        IMessage RM = new RMessage();
        //返回全部会员
        TMessage TM = RM.GateItem(id);
        this.txtTitle.Text = TM.Title;
        this.txtInfo.Text = TM.Info;
        this.txtDate.Text = TM.Date.ToShortDateString();

    }

    protected void btnDelete_Click(object sender, EventArgs e)
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        IMessage RM = new RMessage();
        RM.Delete(id);
        ShowMessage("删除留言成功！");
        
        this.txtTitle.Text = string.Empty;
        this.txtInfo.Text = string.Empty;
        this.txtDate.Text = string.Empty;
    }
    protected void btnReturn_Click(object sender, EventArgs e)
    {
        Response.Redirect("Message.aspx");
    }
}
