﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Corporation.News;

public partial class admin_Corp_News_NewsEdit : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("User", "C1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        if (Request.QueryString["ID"] != null || Request.QueryString["ID"] != "")
        {
            int id = int.Parse(Request.QueryString["ID"].ToString());
            INews RNew = new RNews();
            TNews TNew = RNew.GateItem(id);
            txtTitle.Text = TNew.Title;
            Detail.Value = TNew.Info;
        }

    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null)
        {
            try
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                INews RNew = new RNews();
                TNews TNew = new TNews();
                TNew.ID = id;
                TNew.Title = txtTitle.Text.Trim();
                TNew.Info = Common.ClearHtml(Detail.Value);
                RNew.Update(TNew);
                ShowMessage("公司新闻修改成功！", "Corp/News/NewsList.aspx");
            }
            catch (Exception ex)
            {

                ShowMessage("公司新闻修改失败！", "Corp/News/NewsList.aspx");
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script language=javascript>window.location.href='NewsList.aspx'</script>");
    }
}
