﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Corporation.News;

public partial class admin_Corp_News_NewsList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("User", "C1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
        string strWhere = "1=1";
        string Title = txtTitle.Text.Trim();
        string CompanyName = txtCompany.Text.Trim();
        if (Title != "")
            strWhere += " and Title like '%" + Title + "%'";
        if (CompanyName != "")
            strWhere += " and CompanyName like '%" + CompanyName + "%'";
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        if (Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            PageNo1.PageSize = 12;
            if (Session["strWhere"] != null)
            {
                PageNo1.Where = Session["strWhere"].ToString();
            }
            else
            {
                PageNo1.Where = "1=1";
            }
            PageNo1.Table = "C_news INNER JOIN U_UserInfo ON C_news.UserID =U_UserInfo.UserID";
            PageNo1.FldName = "AddDate";
            PageNo1.StrGetFields = "C_news.*,U_UserInfo.CompanyName";
            DataTable table = PageNo1.BindViewDesc();
            grdCorpNews.DataSource = table.DefaultView;
            grdCorpNews.DataBind();
        }
        else
        {
            PageNo1.Pageindex = 1;
            PageNo1.PageSize = 12;
            PageNo1.Where = "1=1";
            PageNo1.Table = "C_news INNER JOIN U_UserInfo ON C_news.UserID =U_UserInfo.UserID";
            PageNo1.FldName = "AddDate";
            PageNo1.StrGetFields = "C_news.*,U_UserInfo.CompanyName";
            DataTable table = PageNo1.BindViewDesc();
            grdCorpNews.DataSource = table.DefaultView;
            grdCorpNews.DataBind();
        }
    }
    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return string.Empty;
    }
    protected void grdCorpNews_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        grdCorpNews.PageIndex = e.NewPageIndex;
        Bind();
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < grdCorpNews.Rows.Count; i++)
        {
            CheckBox cbox = (CheckBox)grdCorpNews.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int id = Convert.ToInt32(grdCorpNews.DataKeys[i].Value);
                INews RNew = new RNews();
                RNew.Delete(id);
            }
        }
        Bind();
    }
    protected void lbtnUpdate_Command(object sender, CommandEventArgs e)
    {
        //更新审核信息
        TNews TNew = new TNews();
        string Content = e.CommandArgument.ToString();
        int index = Content.IndexOf("|");
        if (index < -1 || index + 1 > Content.Length)
            return;

        TNew.ID = Convert.ToInt32(Content.Substring(0, index));
        TNew.Verify = Convert.ToBoolean(Content.Substring(index + 1));
        INews RNew = new RNews();
        RNew.UpdateVerify(TNew);
        Bind();
    }
    protected void grdCorpNews_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        //弹出警告对话框
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
            LinkButton btn = (LinkButton)e.Row.FindControl("lbtnUpdate");
            if (btn.Text == "已审")
                btn.Attributes.Add("onclick", "javascript:return confirm('您确认要取消审核吗？')");
            else
                btn.Attributes.Add("onclick", "javascript:return confirm('您确认要让该会员通过审核吗？')");

        }
    }
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        string strWhere = "1=1";
        string Title = txtTitle.Text.Trim();
        string CompanyName = txtCompany.Text.Trim();
        if (Title != "")
            strWhere += " and Title like '%" + Base.GetRequest.Filter(Title) + "%'";
        if (CompanyName != "")
            strWhere += " and CompanyName like '%" + Base.GetRequest.Filter(CompanyName) + "%'";
        Session["strWhere"] = strWhere;
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx?page=1";
        Response.Redirect(strURl);
        Response.End();
    }
    protected void grdCorpNews_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = int.Parse(grdCorpNews.DataKeys[e.RowIndex].Value.ToString());
        INews RNew = new RNews();
        RNew.Delete(id);
        Bind();
    }
}
