﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Corporation.Product;

public partial class admin_Corp_ProType_ProTypeList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("User", "C1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
        string strWhere = "1=1";
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        if (Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            PageNo1.PageSize = 12;
            if (Session["strWhere"] != null)
            {
                PageNo1.Where = Session["strWhere"].ToString();
            }
            else
            {
                PageNo1.Where = "1=1";
            }
            PageNo1.Table = "C_ProType as a left join U_UserInfo as b on a.UserID=b.UserID";
            PageNo1.FldName = "a.AddDate";
            PageNo1.StrGetFields = "a.ID,a.Name,a.Sequence,a.AddDate,b.LoginName";
            DataTable table = PageNo1.BindViewDesc();
            dlstProType.DataSource = table.DefaultView;
            dlstProType.DataBind();
        }
        else
        {
            PageNo1.Pageindex = 1;
            PageNo1.PageSize = 12;
            PageNo1.Where = "1=1";
            PageNo1.Table = "C_ProType as a left join U_UserInfo as b on a.UserID=b.UserID";
            PageNo1.FldName = "a.AddDate";
            PageNo1.StrGetFields = "a.ID,a.Name,a.Sequence,a.AddDate,b.LoginName";
            DataTable table = PageNo1.BindViewDesc();
            dlstProType.DataSource = table.DefaultView;
            dlstProType.DataBind();
        }

    }
    
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= dlstProType.Items.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)dlstProType.Items[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int id = Convert.ToInt32(dlstProType.DataKeys[i]);
                IProType RProType = new RProType();
                RProType.Delete(id);
            }
        }
        Bind();
    }
    protected void dlstProType_CancelCommand(object source, DataListCommandEventArgs e)
    {
        dlstProType.EditItemIndex = -1;
        Bind();
    }
    protected void dlstProType_DeleteCommand(object source, DataListCommandEventArgs e)
    {
        int id = Convert.ToInt32(dlstProType.DataKeys[e.Item.ItemIndex]);
        TProType TProType = new TProType();
        TProType.ID = id;
        IProType RProType = new RProType();
        RProType.Delete(id);
        Bind();
    }
    protected void dlstProType_EditCommand(object source, DataListCommandEventArgs e)
    {
        dlstProType.EditItemIndex = e.Item.ItemIndex;
        Bind();
    }
    protected void dlstProType_UpdateCommand(object source, DataListCommandEventArgs e)
    {
        int id = Convert.ToInt32(dlstProType.DataKeys[e.Item.ItemIndex]);
        string name = ((TextBox)e.Item.FindControl("txtName")).Text;
        TProType TProType = new TProType();
        TProType.ID = id;
        TProType.Name = name;
        TProType.AddDate = DateTime.Now;
        IProType RProType = new RProType();
        RProType.Update(TProType);
        dlstProType.EditItemIndex = -1;
        Bind();
    }
}
