﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using UserInfo;
using VipGrade;

public partial class Admin_Corp_UserInfo_LoginInfoEdit : BasePage
{
    private static string _Password = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("User", "A1");
        if (!Page.IsPostBack)
        {
            VipGradeBind();
            Bind();
        }
    }
    private void VipGradeBind()
    {
        IVipGrade vip = new RVipGrade();
        DataSet ds=vip.GetDataTable();
        dropVipGrade.DataSource = ds.Tables[0].DefaultView;
        dropVipGrade.DataTextField = "name";
        dropVipGrade.DataValueField = "ID";
        dropVipGrade.DataBind();
    }
    private void Bind()
    {
        if (Request.QueryString["UserID"] != null && Request.QueryString["UserID"] != "")
        {
            int userid = int.Parse(Request.QueryString["UserID"].ToString());
            IUserInfo RUser = new RUserInfo();
            TUserInfo TUser = RUser.GateItem(userid);
            dropVipGrade.SelectedValue = TUser.GradeID.ToString();
            txtName.Text = TUser.LoginName;
            _Password = TUser.Password;
            txtPassword.Attributes.Add("value", TUser.Password);
            dropQuestion.SelectedValue = TUser.Question;
            txtAnswer.Text = TUser.Answer;
            txtStartDate.Text = DateTime.Parse(TUser.StartDate.ToString()).ToShortDateString();
            txtEndDate.Text = DateTime.Parse(TUser.EndDate.ToString()).ToShortDateString();
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["UserID"] != null && Request.QueryString["UserID"] != "")
        {
            int userid = int.Parse(Request.QueryString["UserID"].ToString());
            TUserInfo TUser = new TUserInfo();
            TUser.UserID = userid;
            TUser.GradeID = int.Parse(dropVipGrade.SelectedValue);
            if (_Password.Equals(txtPassword.Text.Trim()))
            {
                TUser.Password = _Password;
            }
            else
            {
                 string Md5Pawd = Common.Encryption(txtPassword.Text.Trim());
                 TUser.Password = Md5Pawd;
            }
            TUser.Question = dropQuestion.SelectedValue;
            TUser.Answer = txtAnswer.Text;
            if (GetRequest.isDataTime(txtStartDate.Text.Trim()))
                TUser.StartDate = DateTime.Parse(txtStartDate.Text.Trim());
            else
                TUser.StartDate = DateTime.Now;
            if (GetRequest.isDataTime(txtEndDate.Text.Trim()))
                TUser.EndDate = DateTime.Parse(txtEndDate.Text.Trim());
            else
                TUser.EndDate = DateTime.Now;
            IUserInfo RUser = new RUserInfo();
            RUser.UpdateLogin(TUser);
            ShowMessage("会员信息修改成功！", "Corp/UserInfo/UserInfo.aspx");
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("UserInfo.aspx");
    }

}
