﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UserInfo;
using Base;
using Product;

public partial class admin_UserInfo_UserEdit : Base.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("User", "A1");
        if (!IsPostBack)
        {
            LinkManBind();
            CompanyBind();
        }
        this.country.Attributes.Add("onChange", "diqu(this)");
    }    
    /// <summary>
    /// 绑定联系人信息
    /// </summary>
    public void LinkManBind()
    {
        if (Request.QueryString["UserID"] != null)
        {
            int UserID = int.Parse(Request.QueryString["UserID"].ToString());
            IUserInfo RUser = new RUserInfo();
            TUserInfo TUser = RUser.GateItem(UserID);
            txtlinkName.Text = TUser.LinkName;
            radlSex.SelectedValue = TUser.Sex;
            txtDepartment.Text = TUser.Department;
            txtPosition.Text = TUser.Position;
            txtTel_International.Text = TUser.Tel_International;
            txtTel_DistrictNumber.Text = TUser.Tel_DistrictNumber;
            txtTel_Telephone.Text = TUser.Tel_Telephone;
            txtTel_Ext.Text = TUser.Tel_Ext;
            txtFax_International.Text = TUser.Fax_International;
            txtFax_DistrictNumber.Text = TUser.Fax_DistrictNumber;
            txtFax_Telephone.Text = TUser.Fax_Telephone;
            txtFax_Ext.Text = TUser.Fax_Ext;
            txtMobilePhone.Text = TUser.MobilePhone;
            txtEmail.Text = TUser.Email;
            txtQQ.Text = TUser.QQ;
            txtMSN.Text = TUser.MSN;
            Session["strGradeID"] = TUser.GradeID;
        }

    }
    /// <summary>
    /// 绑定公司信息
    /// </summary>
    private void CompanyBind()
    {

        if (Request.QueryString["UserID"] != null)
        {
            int UserID = int.Parse(Request.QueryString["UserID"].ToString());
            IUserInfo RCorp = new RUserInfo();
            TUserInfo TCorp = RCorp.GateItem(UserID);
            this.txtCompanyName.Text = TCorp.CompanyName;
            this.radlCompanyNature.SelectedValue = TCorp.CompanyNature;
            this.chklBusinessModel.SelectedValue = TCorp.BusinessModel;
            this.txtDealinAdd.Text = TCorp.DealinAdd;
            this.txtProduct.Text = TCorp.Product;
            this.Summary.Value = TCorp.Summary;

            this.txtStreet.Text = TCorp.Street;
            this.txtPostalcode.Text = TCorp.Postalcode;
            this.txtURL.Text = TCorp.URL;
            this.txtCapital.Text = TCorp.Capital.ToString();
            this.txtEstablished.Text = TCorp.Established.ToShortDateString();
            this.txtRegisterAddress.Text = TCorp.RegisterAddress;
            this.country.Value = TCorp.Country;
            this.txtProvince.Value = TCorp.Province;
            this.txtCity.Value = TCorp.City;
            this.txtCounty.Value = TCorp.Area;
            this.txtCorporate.Text = TCorp.Corporate;
            this.ImgUrl.Src = TCorp.Logo;
            string strIndustry = TCorp.Industry;           
            if (TCorp.Industry != null)
            {
                string[] str = TCorp.Industry.Split(new char[] { ',' });
                for (int i = 0; i < str.Length; i++)
                {
                    if (i == 0)
                        this.txtSortB.Value = str[i];
                    else if (i == 1)
                        this.txtSortM.Value = str[i];
                    else
                        this.txtSortS.Value = str[i];
                }
            }
            if (TCorp.BusinessModel != null)
            {
                string[] str = TCorp.BusinessModel.Split(new char[] { ',' });
                for (int i = 0; i < str.Length; i++)
                {
                    if (str[i].ToString() != "")
                        this.chklBusinessModel.Items[Convert.ToInt32(str[i])].Selected = true;
                }
            }
        }
    }
    protected void btnUpdate_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["UserID"] != null && Request.QueryString["UserID"] != "")
        {
            try
            {
                string myValue1 = "";
                if (Request.Form["ctl00$ContInfo$SortB"] != null && Request.Form["ctl00$ContInfo$SortB"] != "")
                    myValue1 += Request.Form["ctl00$ContInfo$SortB"] + ",";
                if (Request.Form["ctl00$ContInfo$SortM"] != null && Request.Form["ctl00$ContInfo$SortM"] != "")
                    myValue1 += Request.Form["ctl00$ContInfo$SortM"] + ",";
                if (Request.Form["ctl00$ContInfo$SortS"] != null && Request.Form["ctl00$ContInfo$SortS"] != "")
                    myValue1 += Request.Form["ctl00$ContInfo$SortS"];
                string Industry = myValue1;
                int UserID = int.Parse(Request.QueryString["UserID"].ToString());
                TUserInfo TUser = new TUserInfo();
                IUserInfo RUser = new RUserInfo();

                //修改联系人信息
                TUser.UserID = UserID;
                TUser.LinkName = this.txtlinkName.Text;
                TUser.Sex = this.radlSex.SelectedValue.ToString();
                TUser.Department = this.txtDepartment.Text;
                TUser.Position = this.txtPosition.Text;
                TUser.Tel_International = this.txtTel_International.Text;
                TUser.Tel_DistrictNumber = this.txtTel_DistrictNumber.Text;
                TUser.Tel_Telephone = this.txtTel_Telephone.Text;
                TUser.Tel_Ext = this.txtTel_Ext.Text;
                TUser.Fax_International = this.txtFax_International.Text;
                TUser.Fax_DistrictNumber = this.txtFax_DistrictNumber.Text;
                TUser.Fax_Telephone = this.txtFax_Telephone.Text;
                TUser.Fax_Ext = this.txtFax_Ext.Text;
                TUser.MobilePhone = this.txtMobilePhone.Text;
                TUser.Email = this.txtEmail.Text;
                TUser.QQ = this.txtQQ.Text;
                TUser.MSN = this.txtMSN.Text;
                RUser.UpdateLinkMan(TUser);

                //修改公司信息
                string myValue = "";
                string CompanyName = this.txtCompanyName.Text;
                string CompanyNature = this.radlCompanyNature.Text;
                foreach (ListItem li in chklBusinessModel.Items)
                {
                    if (li.Selected)
                    {
                        myValue += li.Value + ',';
                    }

                }
                if (myValue != "")
                {
                    myValue = myValue.Substring(0, myValue.Length - 1);
                }
                int Capital = int.Parse(this.txtCapital.Text);
                DateTime Established = Convert.ToDateTime(this.txtEstablished.Text);
                string RegisterAddress = this.txtRegisterAddress.Text;
                string Country = this.country.Value;
                string Province = Request.Form["province"];

                string City = Request.Form["city"];
                string County = Request.Form["county"];
                string DealinAdd = this.txtDealinAdd.Text;
                string Postalcode = this.txtPostalcode.Text;
                string Product = this.txtProduct.Text;
                string Summary = this.Summary.Value;
                string Street = this.txtStreet.Text;
                string URL = this.txtURL.Text;
                string Corporate = this.txtCorporate.Text;
                string strLogo = "";
                if (this.ImgUrl1.Value.ToString() != "")
                    strLogo = this.ImgUrl1.Value.ToString();
                else
                    strLogo = this.ImgUrl.Src;
               // string Logo1 = this.ImgUrl1.Value.ToString();
                TUser.UserID = UserID;
                TUser.CompanyName = CompanyName;
                TUser.CompanyNature = CompanyNature;
                TUser.BusinessModel = myValue;
                TUser.Capital = Capital;
                TUser.Established = Established;
                TUser.RegisterAddress = RegisterAddress;
                TUser.Country = Country;
                TUser.Province = Province;
                TUser.City = City;
                TUser.Area = County;
                TUser.DealinAdd = DealinAdd;
                TUser.Product = Product;
                TUser.Industry = Industry;
                TUser.Summary = Summary;
                TUser.Street = Street;
                TUser.Postalcode = Postalcode;
                TUser.URL = URL;
                TUser.Corporate = Corporate;
                TUser.Logo = strLogo;
                TUser.GradeID = Convert.ToInt32(Session["strGradeID"].ToString()); ;
                RUser.UpdateCorpInfo(TUser);
                ShowMessage("会员资料修改成功！", "Corp/UserInfo/UserInfo.aspx");
            }
            catch (Exception ex)
            {
                ex.Message.ToString();
                ShowMessage("会员资料修改失败！", "Corp/UserInfo/UserInfo.aspx");
            }
        }
    }

}
