﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UserInfo;
using Base;
public partial class _UserInfo : Base.BasePage
{
    private int pageSize = 12;//这里设置分页尺寸
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("User", "A1");
        if (!IsPostBack)
        {
            BindVipGrade();
            Bind();
        }
    }
    ///**************************************************
    /// <summary>
    /// depiction：实现对用户的绑定
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Writer：作者中文名
    ///Create Date：<方法创建日期，格式：YYYY-MM-DD>
    ///**************************************************

    private void Bind()
    {
        DataTable table = new DataTable();
        table.Clear();
        string strWhere = " 1=1";
        string LoginName = txtLoginName.Text;
        string CompanyName = txtCompanyName.Text;
        int LoginGrade = Convert.ToInt32(txtGrade.SelectedValue.ToString());

        if (LoginName != "")
            strWhere += " and LoginName like '%" + LoginName + "%'";
        if (CompanyName != "")
            strWhere += " and CompanyName like '%" + CompanyName + "%'";
        if (LoginGrade != 0)
        {
            strWhere += " and GradeID = " + LoginGrade + "";
        }
        if (Request.QueryString["v"] != null)
        {
            string strVerify = Request.QueryString["v"].ToString();
            switch (strVerify)
            {
                case "0": this.Label1.CssClass = "pl"; break;
                case "1": this.Label2.CssClass = "pl"; strWhere += " and Verify=1"; break;
                case "2": this.Label3.CssClass = "pl"; strWhere += " and Verify=0"; break;
            }
        }
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        if (Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            PageNo1.PageSize = 12;
            if (ViewState["strWhere"] != null)
            {
                PageNo1.Where = ViewState["strWhere"].ToString();
            }
            else
            {
                PageNo1.Where = strWhere;
            }
            PageNo1.Table = "U_UserInfo inner join U_VipGrade on (U_UserInfo.GradeID=U_VipGrade.id)";
            PageNo1.FldName = "RegDate";
            PageNo1.StrGetFields = "*";
            table = PageNo1.BindViewDesc();
            grdUser.DataSource = table.DefaultView;
            grdUser.DataBind();
        }
        else
        {
            PageNo1.Pageindex = 1;
            PageNo1.PageSize = 12;
            PageNo1.Where = strWhere;
            if (ViewState["strWhere"] != null)
            {
                PageNo1.Where = ViewState["strWhere"].ToString();
            }
            else
            {
                PageNo1.Where =strWhere;
            }
            ViewState["strWhere"] = PageNo1.Where;
            PageNo1.Table = "U_UserInfo inner join U_VipGrade on(U_UserInfo.GradeID=U_VipGrade.id)";
            PageNo1.FldName = "RegDate";
            PageNo1.StrGetFields = "*";
            table = PageNo1.BindViewDesc();
            grdUser.DataSource = table.DefaultView;
            grdUser.DataBind();
        }
    }
    private void BindVipGrade()
    {
        RUserInfo Gradetype = new RUserInfo();
        DataTable dt = Gradetype.GetDataType("U_VipGrade");
        if (dt.Rows.Count == 0)
            return;
        txtGrade.DataSource = dt.DefaultView;
        txtGrade.DataValueField = "ID";
        txtGrade.DataTextField = "Name";
        txtGrade.DataBind();
        txtGrade.Items.Insert(0, new ListItem("全部", "0"));
    }
    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return string.Empty;
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= grdUser.Rows.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)grdUser.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {

                int UserID = Convert.ToInt32(grdUser.DataKeys[i].Value);
                IUserInfo RUser = new RUserInfo();
                int m = RUser.Delete(UserID);
            }
        }
        Bind();
    }
    protected void lbtnUpdate_Command(object sender, CommandEventArgs e)
    {

        TUserInfo TUser = new TUserInfo();
        string Content = e.CommandArgument.ToString();
        int index = Content.IndexOf("|");
        int userid = int.Parse(Content.Substring(0, index));
        if (index < -1 || index + 1 > Content.Length)
            return;

        TUser.UserID = userid;
        TUser.Verify = Convert.ToBoolean(Content.Substring(index + 1));
        IUserInfo RUser = new RUserInfo();
        RUser.UpdateVerify(TUser);
        Bind();
        //会员信息审核通过发送邮件通知会员
        LinkButton btn = sender as LinkButton;
        int rowIndex = (btn.NamingContainer as GridViewRow).RowIndex;
        int id = int.Parse(grdUser.DataKeys[rowIndex].Value.ToString());
        if (btn.Text != "已审")
        {
            string strFlag = Base.XMLProcess.Read("xml/EmailFlag.xml", "/Item/flag/mode[@type='userVerify']", "value");
            if (strFlag == "")
                strFlag = "us_verify";
            nspBase.Core.clsEmail.SendMail(strFlag, id);
        }

    }
    protected void grdUser_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
            LinkButton btn = (LinkButton)e.Row.FindControl("lbtnUpdate");
            LinkButton btnLock = (LinkButton)e.Row.FindControl("lbtnUpdateLockedup");
            if (btn.Text == "已审")
                btn.Attributes.Add("onclick", "javascript:return confirm('你要取消审核吗？')");
            else
                btn.Attributes.Add("onclick", "javascript:return confirm('你要让该会员通过审核吗？请注意该会员是否满足该等级的条件要求！通过审核后,将开通该会员服务功能？')");
            if (btnLock.Text == "已锁定")
                btnLock.Attributes.Add("onclick", "javascript:return confirm('你要取消锁定吗？')");
            else
                btnLock.Attributes.Add("onclick", "javascript:return confirm('你要锁定吗？')");

        }



    }
    protected void lbtnUpdateLockedup_Command(object sender, CommandEventArgs e)
    {
        TUserInfo TUser = new TUserInfo();
        string Content = e.CommandArgument.ToString();
        int index = Content.IndexOf("|");
        if (index < -1 || index + 1 > Content.Length)
            return;

        TUser.UserID = int.Parse(Content.Substring(0, index));
        TUser.Verify = Convert.ToBoolean(Content.Substring(index + 1));
        IUserInfo RUser = new RUserInfo();
        RUser.UpdateLocked(TUser);
        Bind();
    }
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        string strWhere = " 1=1";
        string LoginName = Base.GetRequest.Filter(txtLoginName.Text.Trim());
        string CompanyName = Base.GetRequest.Filter(txtCompanyName.Text.Trim());
        int LoginGrade = Convert.ToInt32(Base.GetRequest.Filter(txtGrade.SelectedValue));

        if (LoginName != "")
            strWhere += " and LoginName like '%" + LoginName + "%'";
        if (CompanyName != "")
            strWhere += " and CompanyName like '%" + CompanyName + "%'";
        if (LoginGrade != 0)
        {
            strWhere += " and GradeID = " + LoginGrade + "";
        }
        else
        {
            strWhere += "";
        }
        ViewState["strWhere"] = strWhere;
        Bind();
    }


    protected void lnkdelete_Command(object sender, CommandEventArgs e)
    {
        int UserID = Convert.ToInt32(e.CommandArgument.ToString());
        IUserInfo RUser = new RUserInfo();
        int m = RUser.Delete(UserID);
        Bind();
    }
    /// <summary>
    /// 审核通过
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Button1_Click(object sender, EventArgs e)
    {
        IUserInfo RUser = new RUserInfo();
        try
        {
            string strID = "";
            for (int i = 0; i <= grdUser.Rows.Count - 1; i++)
            {
                CheckBox cbox = (CheckBox)grdUser.Rows[i].FindControl("CheckBox1");
                if (cbox.Checked == true)
                {
                    strID += "," + Convert.ToInt32(grdUser.DataKeys[i].Value);
                }
            }
            if (Solely.Other.UpOnlyDate("U_UserInfo", "Verify=1", "UserID in(" + strID.Substring(1) + ")"))
            {
                Bind();

            }
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }
    /// <summary>
    /// 审核未通过
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Button2_Click(object sender, EventArgs e)
    {
        IUserInfo RUser = new RUserInfo();
        try
        {
            string strID = "";
            for (int i = 0; i <= grdUser.Rows.Count - 1; i++)
            {
                CheckBox cbox = (CheckBox)grdUser.Rows[i].FindControl("CheckBox1");
                if (cbox.Checked == true)
                {
                    strID += "," + Convert.ToInt32(grdUser.DataKeys[i].Value);
                }
            }
            if (Solely.Other.UpOnlyDate("U_UserInfo", "Verify=0", "UserID in(" + strID.Substring(1) + ")"))
            {
                Bind();

            }
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }
}
