﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SqlOperate;
using nspBase.Core;
using nspEmail.Lables;
using nspEmail;
using Base;

public partial class Admin_Email_EmailSend : Base.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            CheckRights("Basic", "D1");
            BindData();
        }
    }
    private void BindData()
    {
        ddlist.Items.Add(new ListItem("---请选择---", "-1"));
        ddlist.Items.Add(new ListItem("所有会员", "0"));
        string sql = "select ID,Name from U_VipGrade";
        DataTable dt = SqlHelper.ExecuteSqlQuery(sql);
        if (dt.Rows.Count!= 0)
        {
            foreach (DataRow dataRow in dt.Rows)
            {
                ddlist.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));
            }
        }
        dt.Clear();
        dt.Dispose();
        foreach (ListItem li1 in ddlist.Items)
        {
            if (li1.Value.ToString() == "-1")
            {
                li1.Selected = true;
            }
        }
    }
    protected void btnSend_Click(object sender, EventArgs e)
    {
        lblMessage.Text = "";
        if (txtTitle.Text.Trim() == "")
        {
            lblMessage.Text += "邮件主题";
        }
        if (txtBody.Text.Trim() == "")
        {
            lblMessage.Text += "邮件内容";
        }
        if (lblMessage.Text != "")
        {
            lblMessage.Text += "不能为空!";
            return;
        }
        if (txtTo.Text.Trim() != null)
        {
            string strEmil = txtTo.Text.Trim();
            string[] sArray = strEmil.Split(',');
            bool strEmail;
            foreach (string i in sArray)
            {
               strEmail=Common.isMail(i.ToString());
               if (!strEmail)
               {
                   lblMessage.Text = "邮箱地址格式不正确!";
                   return;
               }
            }
        }
        string strUrl = ddlist.SelectedValue;
        string strWhere="";
        if (strUrl != "0" && strUrl != "-1")
            strWhere = "GradeID=" + strUrl + "";
        else
        {
            if (strUrl == "0")
                strWhere = "1=1";
        }
        string strToEmail = "";
        if (strUrl != "-1")
        {
            string sql = "select Email from U_UserInfo where " + strWhere;
            DataTable dt = SqlHelper.ExecuteSqlQuery(sql);            
            if (dt.Rows.Count != 0)
            {
                for (int k = 0; k < dt.Rows.Count; k++)
                {
                    strToEmail += dt.Rows[k]["Email"].ToString() + ",";
                }
                strToEmail = strToEmail.TrimEnd(new char[] { ',' });
            }
            if (txtTo.Text.Trim() != null)
                strToEmail += ","+txtTo.Text.ToString();
        }

        if (strToEmail == null || strToEmail == "")
        {
            lblMessage.Text = "收件人不能为空!";
            return;
        }
        bool strisHtml;
        if (isRadio.SelectedValue == "1")
            strisHtml = false;
        else
            strisHtml = true;
        lblMessage.Text = clsEmail.SendMail(strToEmail, GetRequest.Filtrate(txtTitle.Text.Trim()), GetRequest.Filtrate(txtBody.Text.Trim()), strisHtml);
        ShowMessage("发送成功!", "Email/EmailSend.aspx");
    }
}
