﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspEmail;
using nspEmail.Lables;
using SqlOperate;
using nspBase.Core;

public partial class Admin_Email_EmailStatistics : Base.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            CheckRights("Basic", "D1");
            Bind();
        }
    }
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
        string strUrlTo = Request.RawUrl;
        strUrlTo = strUrlTo.Substring(0, strUrlTo.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strUrlTo;
        PageNo1.PageSize = 12;
        PageNo1.Table = "W_EmailStatistics as a inner join U_UserInfo b on a.UserID=b.UserID";
        PageNo1.FldName = "AddDate";
        PageNo1.StrGetFields = "a.ID,a.State,a.SubscriptionType,a.AddDate,b.LoginName,b.UserID";
        PageNo1.Where = "1=1";
        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据！";
            }
            else
                lblMessage.Visible = false;
            dlEmaillist.DataSource = dt.DefaultView;
            dlEmaillist.DataBind();
        }
        else
        {
            PageNo1.Pageindex = 1;
            DataTable dt = PageNo1.BindViewDesc();            
            dlEmaillist.DataSource = dt.DefaultView;
            dlEmaillist.DataBind();
        }
    }
    protected void dlEmaillist_DeleteCommand(object source, DataListCommandEventArgs e)
    {
        int id = int.Parse(dlEmaillist.DataKeys[e.Item.ItemIndex].ToString());
        EmailStatistics email = new EmailStatistics();
        email.Delete(id);
        string strUrlTo = Request.RawUrl;
        strUrlTo = strUrlTo.Substring(0, strUrlTo.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strUrlTo + "?page=1");
        Response.End();
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < dlEmaillist.Items.Count; i++)
        {
            CheckBox cbox = (CheckBox)dlEmaillist.Items[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int id = int.Parse(dlEmaillist.DataKeys[i].ToString());
                EmailStatistics email = new EmailStatistics();
                email.Delete(id);
            }

        }
        string strUrlTo = Request.RawUrl;
        strUrlTo = strUrlTo.Substring(0, strUrlTo.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strUrlTo + "?page=1");
        Response.End();
    }
    protected void dlEmaillist_UpdateCommand(object source, DataListCommandEventArgs e)
    {
        string strType = ((Label)e.Item.FindControl("lblType")).Text;
        string strUserID = ((Label)e.Item.FindControl("lblUserID")).Text;
        string strMessage = "";
        if (strType == "商机资讯")
        {
            string sql2 = "select top 10 a.Type as TypeID,a.UserID,b.Email as Email,c.LoginName  from U_SubscriptionNews a inner join U_SubscriptionEmail b on a.UserID=b.UserID inner join U_UserInfo c on b.UserID=c.UserID where c.UserID =" + strUserID + "";
            strMessage = new EmailTempinc().GetTemplate("us_SubScriptionNews", sql2);
        }
        else if (strType == "商机快递")
        {
            string sql2 = "select a.Email,a.UserID,a.ID as TypeID,c.LoginName  from U_SubscriptionEmail as a inner join U_UserInfo c on a.UserID=c.UserID where a.UserID=" + strUserID + "";
            strMessage = new EmailTempinc().GetTemplate("us_SubscriptionProduct", sql2);
        }
        else {
            if (strType == "会员")
            {
                DataTable dt = new DataTable();
                string sql1 = "select a.UserID,a.LoginName,a.Email,b.Extend from U_UserInfo a inner join W_EmailStatistics b on a.UserID=b.UserID where a.UserID=" + strUserID + "";
                dt = SqlHelper.ExecuteSqlQuery(sql1);
                string strName = dt.Rows[0]["LoginName"].ToString();
                string strdateTime = dt.Rows[0]["Extend"].ToString();
                string strEmail = dt.Rows[0]["Email"].ToString();
                dt.Clear();
                dt.Dispose();
                string strBody = EmailTempinc.EmailSend(strName, Int32.Parse(strdateTime));
                strMessage= clsEmail.SendMail("邮件通知", strEmail, strBody);
            }
        }
        lblMessage.Visible = true;
        lblMessage.Text = strMessage;
    }
    protected void btnSend_Click(object sender, EventArgs e)
    {
        string strMessage = "";
        for (int i = 0; i < dlEmaillist.Items.Count; i++)
        {
            CheckBox cbox = (CheckBox)dlEmaillist.Items[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int id = int.Parse(dlEmaillist.DataKeys[i].ToString());
                string strType=((Label)dlEmaillist.Items[i].FindControl("lblType")).Text;
                string strUserID = ((Label)dlEmaillist.Items[i].FindControl("lblUserID")).Text;                
                if (strType == "商机资讯")
                {
                    string sql2 = "select top 10 a.Type as TypeID,a.UserID,b.Email as Email,c.LoginName  from U_SubscriptionNews a inner join U_SubscriptionEmail b on a.UserID=b.UserID inner join U_UserInfo c on b.UserID=c.UserID where c.UserID =" + strUserID + "";
                    strMessage = new EmailTempinc().GetTemplate("us_SubScriptionNews", sql2);
                }
                else if (strType == "商机快递")
                {
                    string sql2 = "select a.Email,a.UserID,a.ID as TypeID,c.LoginName  from U_SubscriptionEmail as a inner join U_UserInfo c on a.UserID=c.UserID where a.UserID=" + strUserID + "";
                    strMessage = new EmailTempinc().GetTemplate("us_SubscriptionProduct", sql2);
                }
                else
                {
                    if (strType == "会员")
                    {
                        DataTable dt = new DataTable();
                        string sql1 = "select a.UserID,a.LoginName,a.Email,b.Extend from U_UserInfo a inner join W_EmailStatistics b on a.UserID=b.UserID where a.UserID=" + strUserID + "";
                        dt = SqlHelper.ExecuteSqlQuery(sql1);
                        int strUserId =Int32.Parse(dt.Rows[i]["UserID"].ToString());
                        string strName = dt.Rows[i]["LoginName"].ToString();
                        string strdateTime = dt.Rows[i]["Extend"].ToString();
                        string strEmail = dt.Rows[i]["Email"].ToString();
                        dt.Clear();
                        dt.Dispose();
                        string strBody = EmailTempinc.EmailSend(strName, Int32.Parse(strdateTime));
                        strMessage = clsEmail.SendMail("邮件通知", strEmail, strBody);
                        EmailStatistics es = new EmailStatistics();
                        es.UserId = strUserId;
                        es.State = strMessage;
                        es.SubscriptionType = "会员";
                        es.AddDate = DateTime.Now;
                        es.Extend = strdateTime;
                        new EmailStatistics().Insert(es);
                    }
                }
            }
        }
        lblMessage.Visible = true;
        lblMessage.Text = strMessage;
    }
}
