﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspEmail;

public partial class Admin_Email_EmailTemplateEdit : Base.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Basic", "D1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        if (Request.QueryString["ID"] != null && Request.QueryString["ID"] != "")
        {
            int id = int.Parse(Request.QueryString["ID"].ToString());
            EmailTemplate email = new EmailTemplate();
            EmailTemplate em = email.GetItem(id);
            dropType.SelectedValue = email.Type;
            txtFlag.Text = em.Flag;
            txtName.Text = em.Name;
            txtTitle.Text = em.Title;
            txtContent.Text = em.Content;
            radlisHtml.SelectedValue = em.Ishtml.ToString();
            txtFlag.Enabled = false;
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (txtTitle.Text.Trim() == "")
        {
            lblMessage.Text = "邮件标题不能为空!";
            return;
        }
        if (txtName.Text.Trim() == "")
        {
            lblMessage.Text = "邮件名称不能为空!";
            return;
        }
        if (txtContent.Text.Trim() == "")
        {
            lblMessage.Text = "邮件正文不能为空!";
            return;
        }
        if (Request.QueryString["ID"] != null && Request.QueryString["ID"] != "")
        {
           
            try
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                EmailTemplate email = new EmailTemplate();
                email.ID = id;
                email.Flag = txtFlag.Text.Trim();
                email.Type = dropType.SelectedValue;
                email.Ishtml = Convert.ToBoolean(radlisHtml.SelectedValue);
                email.Name = txtName.Text.Trim();
                email.Title = txtTitle.Text.Trim();
                email.Content = txtContent.Text.Trim();
                email.AddDate = DateTime.Now;
                email.Update(email);
                Response.Write("<script>location = 'EmailTemplateList.aspx'</script>");

            }
            catch (Exception ex)
            {
                ShowMessage(ex.Message);
            }
        }
        else
        {           
            try
            {
                EmailTemplate email = new EmailTemplate();
                email.Flag = txtFlag.Text.Trim();
                email.Type = dropType.SelectedValue;
                email.Ishtml = Convert.ToBoolean(radlisHtml.SelectedValue);
                email.Name = txtName.Text.Trim();
                email.Title = txtTitle.Text.Trim();
                email.Content = txtContent.Text.Trim();
                email.AddDate = DateTime.Now;
                email.Insert(email);
                Response.Write("<script>location = 'EmailTemplateList.aspx'</script>");
            }
            catch (Exception ex)
            {
                ShowMessage(ex.Message);
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        txtName.Text = string.Empty;
        txtTitle.Text = string.Empty;
        txtContent.Text = string.Empty;
    }
}
