﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Expo;
using Base;

public partial class admin_Expo_ExpoAdd : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "C1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        IExpoType RExpoType = new RExpoType();
        DataTable dt = RExpoType.GetDataTable();
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataTextField = "Type";
        dropTypeID.DataBind();

    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            TExpo TExpo = new TExpo();
            TExpo.Title = txtTitle.Text;
            TExpo.TypeID = int.Parse(dropTypeID.SelectedValue);
            if (GetRequest.isDataTime(txtStartDate.Text))
                TExpo.StartDate = Convert.ToDateTime(txtStartDate.Text);
            else
                TExpo.StartDate = DateTime.Now;
            if (GetRequest.isDataTime(txtEndDate.Text))
                TExpo.EndDate = Convert.ToDateTime(txtEndDate.Text);
            else
                TExpo.EndDate = DateTime.Now;
            TExpo.Place = txtPlace.Text;
            TExpo.Authorize = txtAuthorize.Text;
            TExpo.FrontFor = txtFrontFor.Text;
            TExpo.Undertake = txtUndertake.Text;
            TExpo.Aidance = txtAidance.Text;
            TExpo.Summary = txtSummary.Text;
            TExpo.Range = txtRange.Text;
            TExpo.Period = dropPeriod.SelectedValue;
            TExpo.ExpoType = dropExpoType.SelectedValue;
            TExpo.Homepage = txtHomepage.Text;
            TExpo.Picture = ImgUrl1.Value;
            if (GetRequest.isNum(txtShowArea.Text))
                TExpo.ShowArea = int.Parse(txtShowArea.Text);
            else
                TExpo.ShowArea = 0;
            if (GetRequest.isNum(txtBusinessmen.Text))
                TExpo.Businessmen = int.Parse(txtBusinessmen.Text);
            else
                TExpo.Businessmen = 0;
            if (GetRequest.isNum(txtSpectator.Text))
                TExpo.Spectator = int.Parse(txtSpectator.Text);
            else
                TExpo.Spectator = 0;
            if (GetRequest.isNum(txtPrice.Text))
                TExpo.Price = int.Parse(txtPrice.Text);
            else
                TExpo.Price = 0;
            if (GetRequest.isNum(txtMinNum.Text))
                TExpo.MinNum = int.Parse(txtMinNum.Text);
            else
                TExpo.MinNum = 0;
            IExpo RExpo = new RExpo();
            int isEmail = 0;
            RExpo.Insert(TExpo, out isEmail);
            ShowMessage("展会信息添加成功！", "Expo/ExpoList.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("展会信息添加失败！", "Expo/ExpoList.aspx");
        }
    }


    protected void btnCancel_Click(object sender, EventArgs e)
    {
        txtTitle.Text = string.Empty;
        txtStartDate.Text = string.Empty;
        txtEndDate.Text = string.Empty;
        txtPlace.Text = string.Empty;
        txtAuthorize.Text = string.Empty;
        txtFrontFor.Text = string.Empty;
        txtUndertake.Text = string.Empty;
        txtAidance.Text = string.Empty;
        txtSummary.Text = string.Empty;
        txtRange.Text = string.Empty;
        txtHomepage.Text = string.Empty;
        ImgUrl1.Value = string.Empty;
        txtShowArea.Text = string.Empty;
        txtBusinessmen.Text = string.Empty;
        txtSpectator.Text = string.Empty;
        txtPrice.Text = string.Empty;
        txtMinNum.Text = string.Empty;
    }

}


