﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Expo;
using Base;

public partial class admin_Expo_ExpoEdit : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "C1");
        if (!IsPostBack)
        {
            ExpoTypeBind();
            Bind();    
        }
    } 
    private void ExpoTypeBind()
    {
        IExpoType RExpoType = new RExpoType();
        DataTable dt = RExpoType.GetDataTable();
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataTextField = "Type";
        dropTypeID.DataBind();
    }
    private void Bind()
    {
        int id = 0;
        if (Request.QueryString["ID"] != null)
        {
            id = int.Parse(Request.QueryString["ID"].ToString());
        }
        IExpo RExpo = new RExpo();
        TExpo TExpo=RExpo.GateItem(id);
        txtTitle.Text = TExpo.Title;
        dropTypeID.SelectedValue = TExpo.TypeID.ToString();
        txtStartDate.Text = TExpo.StartDate.ToShortDateString();
        txtEndDate.Text = TExpo.EndDate.ToShortDateString();
        txtPlace.Text = TExpo.Place;
        txtAuthorize.Text = TExpo.Authorize;
        txtFrontFor.Text = TExpo.FrontFor;
        txtUndertake.Text = TExpo.Undertake;
        txtAidance.Text = TExpo.Aidance;
        txtSummary.Text = TExpo.Summary;
        txtRange.Text = TExpo.Range;
        dropPeriod.SelectedValue = TExpo.Period;
        dropExpoType.SelectedValue = TExpo.ExpoType;
        txtHomepage.Text = TExpo.Homepage;
        ImgUrl1.Value = TExpo.Picture;
        ImgUrl.Src = TExpo.Picture;
         
        txtShowArea.Text = TExpo.ShowArea.ToString();
        txtBusinessmen.Text = TExpo.Businessmen.ToString();
        txtSpectator.Text = TExpo.Spectator.ToString();
        txtPrice.Text = TExpo.Price.ToString();
        txtMinNum.Text = TExpo.MinNum.ToString();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            int id = 0;
            if (Request.QueryString["ID"] != null)
            {
                id = int.Parse(Request.QueryString["ID"].ToString());
            }
            TExpo TExpo = new TExpo();
            TExpo.ID = id;
            TExpo.Title = txtTitle.Text;
            TExpo.TypeID = int.Parse(dropTypeID.SelectedValue);
            if (GetRequest.isDataTime(txtStartDate.Text))
                TExpo.StartDate = Convert.ToDateTime(txtStartDate.Text);
            else
                TExpo.StartDate = DateTime.Now;
            if (GetRequest.isDataTime(txtEndDate.Text))
                TExpo.EndDate = Convert.ToDateTime(txtEndDate.Text);
            else
                TExpo.EndDate = DateTime.Now;
            TExpo.Place = txtPlace.Text;
            TExpo.Authorize = txtAuthorize.Text;
            TExpo.FrontFor = txtFrontFor.Text;
            TExpo.Undertake = txtUndertake.Text;
            TExpo.Aidance = txtAidance.Text;
            TExpo.Summary = txtSummary.Text;
            TExpo.Range = txtRange.Text;
            TExpo.Period = dropPeriod.SelectedValue;
            TExpo.ExpoType = dropExpoType.SelectedValue;
            TExpo.Homepage = txtHomepage.Text;
            TExpo.Picture = ImgUrl1.Value;
            if (GetRequest.isNum(txtShowArea.Text))
                TExpo.ShowArea = int.Parse(txtShowArea.Text);
            else
                TExpo.ShowArea = 0;
            if (GetRequest.isNum(txtBusinessmen.Text))
                TExpo.Businessmen = int.Parse(txtBusinessmen.Text);
            else
                TExpo.Businessmen = 0;
            if (GetRequest.isNum(txtSpectator.Text))
                TExpo.Spectator = int.Parse(txtSpectator.Text);
            else
                TExpo.Spectator = 0;
            if (GetRequest.isNum(txtPrice.Text))
                TExpo.Price = int.Parse(txtPrice.Text);
            else
                TExpo.Price = 0;
            if (GetRequest.isNum(txtMinNum.Text))
                TExpo.MinNum = int.Parse(txtMinNum.Text);
            else
                TExpo.MinNum = 0;
            IExpo RExpo = new RExpo();
            RExpo.Update(TExpo);
            ShowMessage("展会信息修改成功！", "Expo/ExpoList.aspx");
        }
        catch (Exception ex)
        {

            ShowMessage("展会信息修改失败！", "Expo/ExpoList.aspx");
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script language=javascript>window.location.href='ExpoList.aspx'</script>");
    }
}
