﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Expo;
using Base;

public partial class admin_Expo_ExpoList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "C1");
        if (!IsPostBack)
        {
            ExpoBind();
            Bind();
        }
    }


    private void Bind()
    {        
        btnDelete.Attributes.Add("onclick", "return confirm('你确认要删除吗？')");

        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        string strWhere = "1=1";
        PageNo1.Strurl = strURl;
        PageNo1.Table = "W_Expo left JOIN W_ExpoType on W_Expo.TypeID = W_ExpoType.ID";
        PageNo1.FldName = "W_Expo.AddDate";
        PageNo1.StrGetFields = "W_Expo.*, W_ExpoType.Type";
        PageNo1.PageSize = 12;
        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据";
            }
            else
                lblMessage.Visible = false;
            grdExpo.DataSource = dt.DefaultView;
            grdExpo.DataBind();
        }
        else {
            if (Request.QueryString["TypeID"] != null && Request.QueryString["TypeID"] != "")
            {
                int TypeID = int.Parse(Request.QueryString["TypeID"].ToString());
                strWhere += " and W_Expo.TypeID =" + TypeID;
            }
            if (GetRequest.GetQueryStringValue("V") != "")
            {
                switch (GetRequest.GetQueryStringValue("v"))
                {
                    case "1":
                        this.Label2.CssClass = "pl";
                        strWhere += " and W_Expo.Verify<3";
                        break;
                    case "2":
                        strWhere += " and W_Expo.Verify=3";
                        this.Label3.CssClass = "pl";
                        break;
                    default:
                        this.Label1.CssClass = "pl";
                        break;
                }
            }
            else
            {
                this.Label1.CssClass = "pl";
            }
            string TitleName = Base.GetRequest.Filter(txtKeyword.Text.Trim());
            if (TitleName != "")
                strWhere += " and Name like '%" + TitleName + "%'";
            PageNo1.Pageindex = 1;
            PageNo1.Where = strWhere;
            Session["strWhere"] = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据";
            }
            else
                lblMessage.Visible = false;
            grdExpo.DataSource = dt.DefaultView;
            grdExpo.DataBind();
        }       
    }

    /// <summary>
    /// 展会类别绑定
    /// </summary>
    private void ExpoBind()
    {
        IExpoType RExpo = new RExpoType();
        DataTable dt = RExpo.GetDataTable();
        dropExpoType.DataSource = dt.DefaultView;
        dropExpoType.DataValueField = "ID";
        dropExpoType.DataTextField = "Type";
        dropExpoType.DataBind();
        ListItem li = new ListItem("--+所有分类信息+--", "0");
        dropExpoType.Items.Add(li);
        li.Selected = true;

    }



    protected void grdConsultative_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        grdExpo.SelectedIndex = e.NewPageIndex;
        Bind();
    }


    /// <summary>
    /// 批量删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnDelete_Click(object sender, EventArgs e)
    {
		try
		{
			string strID = "";
        IExpo RExpo = new RExpo();
        for (int i = 0; i < grdExpo.Rows.Count; i++)
        {
            CheckBox cbox = (CheckBox)grdExpo.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += grdExpo.DataKeys[i].Value.ToString() + ",";
                int id = int.Parse(grdExpo.DataKeys[i].Value.ToString());
                string UsUrl = RExpo.GateItem(id).Picture;
                // ThumNail.FileDelete(UsUrl);               
            }
        }
        strID = strID.TrimEnd(new char[] { ',' });
        RExpo.Delete(strID);
        Bind();
		}
		catch (Exception Ex)
		{
		}  
    }


    /// <summary>
    /// 查询
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSelect_Click(object sender, EventArgs e)
    {
        string strWhere = "W_Expo.TypeID = W_ExpoType.ID";
        if (txtKeyword.Text.Trim() != "")
            strWhere = strWhere + " and Title like '%" + Base.GetRequest.Filter(txtKeyword.Text.Trim()) + "%'";
        if (dropExpoType.SelectedValue.ToString() != "0" && dropExpoType.SelectedValue.ToString() != "")
            strWhere = strWhere + " and W_Expo.TypeID ="+dropExpoType.SelectedValue;
        Session["strWhere"] = strWhere;
        string strURl1 = Request.RawUrl;
        strURl1 = strURl1.Substring(0, strURl1.IndexOf(".aspx")) + ".aspx?page=1";
        Response.Redirect(strURl1);
        Response.End();
    }

    protected void lbtnUpdate_Command(object sender, CommandEventArgs e)
    {
        TExpo TExpo = new TExpo();
        string Content = e.CommandArgument.ToString();
        int index = Content.IndexOf("|");
        if (index < -1 || index + 1 > Content.Length)
            return;

        TExpo.ID = int.Parse(Content.Substring(0, index));
        TExpo.Verify = Convert.ToInt32(Content.Substring(index + 1));
        IExpo RExpo = new RExpo();
        RExpo.UpdateVerify(TExpo);
        Bind();
    }



    protected void lnkdelete_Command(object sender, CommandEventArgs e)
    {
        IExpo rs = new RExpo();
        int id = int.Parse(e.CommandArgument.ToString());
        int m = rs.Delete(id);
        Bind();
    }


    /// <summary>
    /// 绑定审核状态
    /// </summary>
    /// <param name="strVerify"></param>
    /// <returns></returns>
    public static string ShowVerify(string strVerify)
    {
        if (strVerify == "1")
        {
            return "通过";
        }
        else if (strVerify == "2")
        {
            return "未通过";
        }
        else
        {
            return "未审";
        }
    }
    protected void grdExpo_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {

            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");

            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this);");

        }
    }
    public string GetShortDate(string date)
    {
        if (date != string.Empty)
        {
            return Convert.ToDateTime(date).ToShortDateString();
        }
        else
            return string.Empty;
    }
    protected void ButEigible_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdExpo.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdExpo.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += "," + Convert.ToInt32(grdExpo.DataKeys[i].Value);
            }
        }
        if (strID == "")
        {
            Base.BasePage.ShowMessage("您还没有选择信息！", "Expo/ExpoList.aspx");
            return;
        }
        if (Solely.Other.UpOnlyDate("W_Expo", "Verify=1", "id in(" + strID.Substring(1) + ")"))
        {
            Bind();
        }
        else
        {
            Base.BasePage.ShowMessage("审核出现错误！", "Expo/ExpoList.aspx");
        }
    }
    protected void ButDisqualification_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdExpo.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdExpo.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += "," + Convert.ToInt32(grdExpo.DataKeys[i].Value);
            }
        }
        if (strID == "")
        {
            Base.BasePage.ShowMessage("您还没有选择信息！", "Expo/ExpoList.aspx");
            return;
        }
        if (Solely.Other.UpOnlyDate("W_Expo", "Verify=2", "id in(" + strID.Substring(1) + ")"))
        {
            Bind();
        }
        else
        {
            Base.BasePage.ShowMessage("审核出现错误！", "Expo/ExpoList.aspx");
        }
    }

    public string GetNewTitle(string Title, string strID)
    {
        string Restr = "<a href=\"" + Base.BasePage.Config.WebURL + "Expo/Detail.aspx?id=" + strID + "\" target=\"blank\">" + Title + "</a>";
        return Restr;
    }

}
