﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Expo;
using Base;

public partial class admin_Expo_ExpoNewsAdd : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "C1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        TExpoNews TExpo = new TExpoNews();
        IExpoNewsType RExpo = new RExpoNewsType();
        DataTable dt = RExpo.GetDataTable();
        dropType.DataSource = dt.DefaultView;
        dropType.DataValueField = "ID";
        dropType.DataTextField = "Type";
        dropType.DataBind();
        ImgUrl1.Value = TExpo.Picture;
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string myValue = "";
            TExpoNews TExpo = new TExpoNews();
            TExpo.Title = txtTitle.Text;
            TExpo.TypeID = int.Parse(dropType.SelectedValue);

            foreach (ListItem li in chklAttribute.Items)
            {
                if (li.Selected)
                {
                    myValue = li.Value + ',';
                }
            }
            if (myValue != "")
                myValue = myValue.Substring(0, myValue.Length - 1);
            TExpo.Attribute = myValue;
            TExpo.Origin = txtOrigin.Text;
            string Temp = GetRequest.RemoveHTMLForEditor(Detail.Value);
            Temp = GetRequest.WipeScript(Temp);
            TExpo.Detail = Temp;
            TExpo.Picture = ImgUrl1.Value;

            IExpoNews RExpo = new RExpoNews();
            RExpo.Insert(TExpo);
            ShowMessage("展会资讯添加成功！", "Expo/ExpoNewsList.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("展会资讯添加失败！", "Expo/ExpoNewsList.aspx");
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        txtTitle.Text = string.Empty;
        txtOrigin.Text = string.Empty;
        Detail.Value = string.Empty;
        ImgUrl1.Value = string.Empty;
        chklAttribute.SelectedValue = string.Empty;
        for (int i = 0; i < chklAttribute.Items.Count; i++)
        {
            chklAttribute.Items[i].Selected = false;
        } 
    }

}
