﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Expo;
using Base;

public partial class admin_Expo_ExpoNewsEdit : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "C1");
        if (!IsPostBack)
        {
            ExpoNewsTypeBind();
            Bind();
        }
       // Upfile1.reStr += showView;
       // Upfile1.MyValue = "Expo";
    }
    private void ExpoNewsTypeBind()
    {
        IExpoNewsType RExpo = new RExpoNewsType();
        DataTable dt = RExpo.GetDataTable();
        dropType.DataSource = dt.DefaultView;
        dropType.DataValueField = "ID";
        dropType.DataTextField = "Type";
        dropType.DataBind();
    }
    private void Bind()
    { 
        int id=0;
        if (Request.QueryString["ID"] != null)
        {
            id = int.Parse(Request.QueryString["ID"].ToString());

            IExpoNews RExpo = new RExpoNews();
            TExpoNews TExpo = RExpo.GateItem(id);
            
            txtTitle.Text = TExpo.Title;
            dropType.SelectedValue = TExpo.TypeID.ToString();
            ImgUrl1.Value = TExpo.Picture;
            ImgUrl.Src = TExpo.Picture;
            //imgPicture.ImageUrl = TExpo.Picture;
            if (TExpo.Attribute != "")
            {
                string[] str = TExpo.Attribute.Split(new char[] { ',' });
                for (int i = 0; i < str.Length; i++)
                {
                    chklAttribute.Items[Convert.ToInt32(str[i])].Selected = true;
                }
              
            }
            txtOrigin.Text = TExpo.Origin;
            Detail.Value = TExpo.Detail;
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            int id=0;
            if (Request.QueryString["ID"] != null)
            {
                id = int.Parse(Request.QueryString["ID"].ToString());
            }
            string myValue = "";
            TExpoNews TExpo = new TExpoNews();
            TExpo.ID = id;
            TExpo.Title = txtTitle.Text;
            TExpo.TypeID = int.Parse(dropType.SelectedValue);
           // TExpo.Picture = imgPicture.ImageUrl;
            TExpo.Picture = ImgUrl1.Value;
            foreach (ListItem li in chklAttribute.Items)
            {
                if (li.Selected)
                {
                    myValue += li.Value + ',';
                }
            }
            if (myValue != "")
                myValue = myValue.Substring(0, myValue.Length - 1);
            TExpo.Attribute = myValue;
            TExpo.Origin = txtOrigin.Text;
            string Temp = GetRequest.RemoveHTMLForEditor(Detail.Value);
            Temp = GetRequest.WipeScript(Temp);
            TExpo.Detail = Temp;
            IExpoNews RExpo = new RExpoNews();
            RExpo.Update(TExpo);
            ShowMessage("展会资讯修改成功！", "Expo/ExpoNewsList.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("展会资讯修改失败！", "Expo/ExpoNewsList.aspx");
        }
    }
    //private void showView(string strUrl)
    //{
    //    this.imgPicture.ImageUrl = strUrl;
    //}
}
