﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Expo;
using Base;
using Agent;

public partial class admin_Expo_ExpoNewsList : BasePage
{
    private int pageSize = 12;//这里设置分页尺寸 
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "C1");
        if (!IsPostBack)
        {
            ExpoNewsTypeBind();
            Bind();
        }
    }
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "return confirm('你确认要删除吗？')");
        //IExpoNews RExpo = new RExpoNews();
        //TExpoNews TExpo = new TExpoNews();
        //DataTable dt;
        //if (Request.QueryString["TypeID"] != null)
        //{
        //    int typeid = int.Parse(Request.QueryString["TypeID"].ToString());
        //    TExpo.TypeID = typeid;
        //    dt = RExpo.GetDataTable(TExpo);
        //    grdExpoNews.DataSource = dt.DefaultView;
        //    grdExpoNews.DataBind();
        //}
        //else
        //{
        //    dt = RExpo.GetDataTable();
        //    grdExpoNews.DataSource = dt.DefaultView;
        //    grdExpoNews.DataBind();
        //}
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        string strWhere = " 1=1 AND W_ExpoNews.TypeID=W_ExpoNewsType.ID ";
        PageNo1.Strurl = strURl;
        PageNo1.Table = "W_ExpoNews,W_ExpoNewsType";
        PageNo1.FldName = "W_ExpoNews.AddDate";
        PageNo1.StrGetFields = "W_ExpoNews.*,W_ExpoNewsType.*";
        PageNo1.PageSize = pageSize;
        if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindView();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdExpoNews.DataSource = dt.DefaultView;
            grdExpoNews.DataBind();
        }
        else
        {
            if (Request.QueryString["ParentId"] != null && Request.QueryString["ParentId"] != "")
            {
                int PaID = int.Parse(Request.QueryString["ParentId"]);
            }
            int ParentID = 0;
            if (Request.QueryString["ParentID"] != null)
            {
                ParentID = int.Parse(Request.QueryString["ParentID"]);
                strWhere += " AND ParentID=" + ParentID;
            }
            Session["strWhere"] = strWhere;
            PageNo1.Where = strWhere;
            PageNo1.Pageindex = 1;
            DataTable dt = PageNo1.BindView();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdExpoNews.DataSource = dt.DefaultView;
            grdExpoNews.DataBind();
        }
    }
    private void ExpoNewsTypeBind()
    {
        IExpoNewsType RExpo = new RExpoNewsType();
        DataTable dt = RExpo.GetDataTable();
        dropExpoNewsType.DataSource = dt.DefaultView;
        dropExpoNewsType.DataValueField = "ID";
        dropExpoNewsType.DataTextField = "Type";
        dropExpoNewsType.DataBind();
        ListItem li = new ListItem("--+所有分类信息+--", "0");
        dropExpoNewsType.Items.Add(li);
        li.Selected = true;
    }
    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < grdExpoNews.Rows.Count; i++)
        {
            CheckBox cbox = (CheckBox)grdExpoNews.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int id = Convert.ToInt32(grdExpoNews.DataKeys[i].Value);
                IExpoNews RExpo = new RExpoNews();
                RExpo.Delete(id);
            }
        }
        Bind();
    }

    protected void btnSelect_Click(object sender, EventArgs e)
    {

        IExpoNews RExpo = new RExpoNews();
        TExpoNews TExpo = new TExpoNews();
        TExpo.Title = txtKeyword.Text;
        TExpo.TypeID = int.Parse(dropExpoNewsType.SelectedValue);
        DataTable dt = RExpo.GetDataTable(TExpo);
        if (dt.Rows.Count == 0)
        {
            lblMessage.Visible = true;
            lblMessage.Text = "<font color='red'>暂无数据</font>";
        }
        else
            lblMessage.Visible = false;
        grdExpoNews.DataSource = dt.DefaultView;
        grdExpoNews.DataBind();
    }
    protected void grdExpoNews_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {

        GridView gv = (GridView)sender;
        int newPageIndex = 0;
        if (-2 == e.NewPageIndex)
        {
            TextBox tb = null;
            GridViewRow gvr = gv.BottomPagerRow;
            if (gvr != null)
            {
                tb = (TextBox)gvr.FindControl("txtNum");

            }
            if (tb != null)
            {
                newPageIndex = int.Parse(tb.Text) - 1;
            }
        }
        else
        {
            newPageIndex = e.NewPageIndex;
        }
        newPageIndex = newPageIndex <= 0 ? 0 : newPageIndex;
        this.grdExpoNews.PageIndex = newPageIndex;
        //分页后重新绑定数据源
        Bind();

    }
    protected void grdExpoNews_RowDataBound1(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {

            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");

            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this);");

        }
    }
    protected void lbtnDel_Command(object sender, CommandEventArgs e)
    {
        int id = int.Parse(e.CommandArgument.ToString());
        try
        {
            IExpoNews RExpo = new RExpoNews();
            RExpo.Delete(id);
            Bind();
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }

    }
    public static string ShowVerify(string strVerify)
    {
        if (strVerify == "1")
        {
            return "通过";
        }
        else if (strVerify == "3")
        {
            return "未通过";
        }
        else
        {
            return "未审";
        }
    }
    protected void ButEigible_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdExpoNews.Rows.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)grdExpoNews.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {

                strID += "," + Convert.ToInt32(grdExpoNews.DataKeys[i].Value);
            }
        }
        if (strID == "")
        {
            Base.BasePage.ShowMessage("您还没有选择信息！", "Expo/ExpoNewsList.aspx");
            return;
        }

        if (Solely.Other.UpOnlyDate("W_ExpoNews", "Verify=1", "id in(" + strID.Substring(1) + ")"))
        {
            Bind();
        }
        else
        {
            Base.BasePage.ShowMessage("审核出现错误！", "Expo/ExpoNewsList.aspx");
        }
    }
    protected void ButDisqualification_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdExpoNews.Rows.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)grdExpoNews.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {

                strID += "," + Convert.ToInt32(grdExpoNews.DataKeys[i].Value);
            }
        }
        if (strID == "")
        {
            Base.BasePage.ShowMessage("您还没有选择信息！", "Expo/ExpoNewsList.aspx");
            return;
        }

        if (Solely.Other.UpOnlyDate("W_ExpoNews", "Verify=3", "id in(" + strID.Substring(1) + ")"))
        {
            Bind();
        }
        else
        {
            Base.BasePage.ShowMessage("审核出现错误！", "Expo/ExpoNewsList.aspx");
        }
    }
}
