﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Expo;
using Base;

public partial class admin_Expo_ExpoNewsTypeList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "C1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        IExpoNewsType RExpo = new RExpoNewsType();
        DataTable dt = RExpo.GetDataTable();
        dlstExpoNewsType.DataSource = dt.DefaultView;
        dlstExpoNewsType.DataBind();

    }

    protected void dlstExpoType_CancelCommand(object source, DataListCommandEventArgs e)
    {
        dlstExpoNewsType.EditItemIndex = -1;
        Bind();
    }
    protected void dlstExpoType_DeleteCommand(object source, DataListCommandEventArgs e)
    {
        int id = int.Parse(dlstExpoNewsType.DataKeys[e.Item.ItemIndex].ToString());
        IExpoNewsType RExpo = new RExpoNewsType();
        RExpo.Delete(id);
        IExpo WExpo = new RExpo();
        WExpo.DeleteByTypeID(id);
        Bind();

    }
    protected void dlstExpoType_EditCommand(object source, DataListCommandEventArgs e)
    {
        dlstExpoNewsType.EditItemIndex = e.Item.ItemIndex;
        Bind();
    }
    protected void dlstExpoType_UpdateCommand(object source, DataListCommandEventArgs e)
    {
        int id = int.Parse(dlstExpoNewsType.DataKeys[e.Item.ItemIndex].ToString());
        string type = ((TextBox)e.Item.FindControl("txtType")).Text;
        TExpoNewsType TExpo = new TExpoNewsType();
        TExpo.ID = id;
        TExpo.Type = type;
        IExpoNewsType RExpo = new RExpoNewsType();
        RExpo.Update(TExpo);
        dlstExpoNewsType.EditItemIndex = -1;
        Bind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string type = txtExpoNewsType.Text;
            TExpoNewsType TExpo = new TExpoNewsType();
            TExpo.Type = type;
            IExpoNewsType RExpo = new RExpoNewsType();
            RExpo.Insert(TExpo);
            ShowMessage("展会资讯类别添加成功！", "Expo/ExpoNewsTypeList.aspx");
            
        }
        catch (Exception ex)
        {
            ShowMessage("展会资讯类别添加失败！", "Expo/ExpoNewsTypeList.aspx");
        }
    }
}
