﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Expo;
using Base;

public partial class admin_Expo_ExpoTypeList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "C1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        IExpoType RExpoType = new RExpoType();
        DataTable dt=RExpoType.GetDataTable();
        dlstExpoType.DataSource = dt.DefaultView;
        dlstExpoType.DataBind();

    }
    protected void dlstExpoType_CancelCommand(object source, DataListCommandEventArgs e)
    {
        dlstExpoType.EditItemIndex = -1;
        Bind();
    }
    protected void dlstExpoType_DeleteCommand(object source, DataListCommandEventArgs e)
    {
        int id = Convert.ToInt32(dlstExpoType.DataKeys[e.Item.ItemIndex]);
        IExpoType RExpoType = new RExpoType();
        RExpoType.Delete(id);
        Bind();
    }
    protected void dlstExpoType_EditCommand(object source, DataListCommandEventArgs e)
    {
        dlstExpoType.EditItemIndex = e.Item.ItemIndex;
        Bind();
    }
    protected void dlstExpoType_UpdateCommand(object source, DataListCommandEventArgs e)
    {
        int id = Convert.ToInt32(dlstExpoType.DataKeys[e.Item.ItemIndex]);
        string type = ((TextBox)e.Item.FindControl("txtType")).Text;
        TExpoType TExpoType = new TExpoType();
        TExpoType.ID = id;
        TExpoType.Type = type;
        IExpoType RExpoType = new RExpoType();
        RExpoType.Update(TExpoType);
        dlstExpoType.EditItemIndex = -1;
        Bind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            TExpoType TExpoType = new TExpoType();
            TExpoType.Type = txtExpoType.Text;
            IExpoType RExpoType = new RExpoType();
            RExpoType.Insert(TExpoType);
            ShowMessage("展会类别添加成功！", "Expo/ExpoTypeList.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("展会类别添加失败！", "Expo/ExpoTypeList.aspx");
        }
    }
}
