﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Help;

public partial class admin_Help_HelpCenterAdd : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "D1");
        if (!IsPostBack)
        {
            HelpTypeBind();
        }
    }
    private void HelpTypeBind()
    {
        DataTable dt;
        IHelpType RHelp = new RHelpType();
        dt = RHelp.GetDataTable(0);
        lstHelpType.DataSource = dt.DefaultView;
        lstHelpType.DataTextField = "Name";
        lstHelpType.DataValueField = "ID";
        lstHelpType.DataBind();
      
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string Restr = "";
            IHelpCenter RHelp = new RHelpCenter();
            THelpCenter THelp = new THelpCenter();

            if (Request.Form["lstHelpType1"] != null)
                THelp.TypeID = int.Parse(Request.Form["lstHelpType1"].ToString());
            else
                THelp.TypeID = int.Parse(lstHelpType.SelectedValue);
            if (txtTitle.Text.Trim() != "")
                THelp.Title = txtTitle.Text.Trim();
            else
                Restr += "信息标题、";
            if (txtInfo.Value != "")
                THelp.Info = txtInfo.Value;
            else
                Restr += "信息内容";
            THelp.AddDate = DateTime.Now;
            if (Restr == "")
            {
                RHelp.Insert(THelp);
                ShowMessage("帮助信息添加成功！", "Help/HelpCenterList.aspx");
            }
            else
            {
                lblMessage.Visible = true;
                lblMessage.Text = Restr + "填写有误！";
               
            }
        }
        catch (Exception ex)
        {

            ShowMessage("帮助信息添加失败！", "Help/HelpCenterList.aspx");
        }
    }

    protected void lstHelpType_SelectedIndexChanged(object sender, EventArgs e)
    {
        DataTable dt;
        IHelpType RHelp = new RHelpType();
        if (lstHelpType.SelectedValue != "")
        {
            int id = int.Parse(lstHelpType.SelectedValue);
            dt = RHelp.GetDataTable(id);
            if (dt.Rows.Count != 0)
            {

                lstHelpType1.DataSource = dt.DefaultView;
                lstHelpType1.DataTextField = "Name";
                lstHelpType1.DataValueField = "ID";
                lstHelpType1.DataBind();
            }
            else
                lstHelpType1.Items.Clear();
        }

    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("HelpCenterList.aspx");
    }
}
