﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Help;

public partial class admin_Help_HelpCenterEdit : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "D1");
        if (!IsPostBack)
        {
            HelpTypeBind();
            Bind();
        }
    }
    private void HelpTypeBind()
    {
        DataTable dt;
        IHelpType RHelp = new RHelpType();
        dt = RHelp.GetDataTable(0);
        lstHelpType.DataSource = dt.DefaultView;
        lstHelpType.DataTextField = "Name";
        lstHelpType.DataValueField = "ID";
        lstHelpType.DataBind();
    }
    private void Bind()
    {
        if (Request.QueryString["ID"] != null && Request.QueryString["ID"] != "")
        {

            int id = int.Parse(Request.QueryString["ID"].ToString());
            IHelpCenter RHelp = new RHelpCenter();
            THelpCenter THelp = RHelp.GateItem(id);

            IHelpType RHe = new RHelpType();
            DataTable dt = RHe.GetDataTable(THelp.TypeID.ToString());
            if (dt.Rows[0]["ParentID"].ToString() != "0")
            {
                int typeid = int.Parse(dt.Rows[0]["ParentID"].ToString());
                lstHelpType.SelectedValue = typeid.ToString();
                DataTable dt1 = RHe.GetDataTable(typeid);


                lstHelpType1.DataSource = dt1.DefaultView;
                lstHelpType1.DataTextField = "Name";
                lstHelpType1.DataValueField = "ID";
                lstHelpType1.DataBind();
                lstHelpType1.SelectedValue = THelp.TypeID.ToString();
            }
            else
                lstHelpType.SelectedValue = THelp.TypeID.ToString();
            txtTitle.Text = THelp.Title;
            txtInfo.Value = THelp.Info;
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null && Request.QueryString["ID"] != "")
        {
            try
            {
                IHelpCenter RHelp = new RHelpCenter();
                THelpCenter THelp = new THelpCenter();
                THelp.ID = int.Parse(Request.QueryString["ID"].ToString());
                if (Request.Form["lstHelpType1"] != null)
                    THelp.TypeID = int.Parse(Request.Form["lstHelpType1"].ToString());
                else
                    THelp.TypeID = int.Parse(lstHelpType.SelectedValue);
                THelp.Title = txtTitle.Text.Trim();
                THelp.Info = txtInfo.Value;
                THelp.AddDate = DateTime.Now;
                RHelp.update(THelp);
                ShowMessage("帮助信息修改成功！", "Help/HelpCenterList.aspx");
            }
            catch (Exception ex)
            {
                ShowMessage("帮助信息修改失败！", "Help/HelpCenterList.aspx");
            }
        }
    }

    protected void lstHelpType_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (lstHelpType.SelectedValue != "")
        {
            int id = int.Parse(lstHelpType.SelectedValue);
            IHelpType RHelp = new RHelpType();
            DataTable dt = RHelp.GetDataTable(id);
            if (dt.Rows.Count != 0)
            {

                lstHelpType1.DataSource = dt.DefaultView;
                lstHelpType1.DataTextField = "Name";
                lstHelpType1.DataValueField = "ID";
                lstHelpType1.DataBind();
            }
            else
                lstHelpType1.Items.Clear();
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("HelpCenterList.aspx");
    }
}
