﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Help;

public partial class admin_Help_HelpCenterList : BasePage
{   
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "D1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    #region 数据绑定
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
        try
        {
            string strURl = Request.RawUrl;
            strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
            string strWhere = " 1=1";
            PageNo1.Strurl = strURl;
            PageNo1.FldName = "AddDate";
            PageNo1.Table = "W_HelpCenter a inner join W_HelpType b on a.TypeID=b.ID";
            PageNo1.StrGetFields = "a.ID,a.Title,a.Info,a.AddDate,b.Name";
            PageNo1.PageSize = 12;
            DataTable dt = new DataTable();
            if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
            {
                PageNo1.Pageindex = Int32.Parse(Request.QueryString["page"].ToString());
                PageNo1.Where = strWhere;
                dt = PageNo1.BindViewDesc();
            }
            else { 
                PageNo1.Pageindex = 1;
                PageNo1.Where = strWhere;
                dt = PageNo1.BindViewDesc();
            }
            gvHelpCenter.DataSource = dt.DefaultView;
            gvHelpCenter.DataBind();
            dt.Clear();
            dt.Dispose();
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }
    #endregion
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        try
        {
            string strId = "";
            for (int i = 0; i <= gvHelpCenter.Rows.Count - 1; i++)
            {

                CheckBox cbox = (CheckBox)gvHelpCenter.Rows[i].FindControl("CheckBox1");
                if (cbox.Checked == true)
                {
                    strId += gvHelpCenter.DataKeys[i]["ID"].ToString() + ",";                   
                }
            }
            if (strId != "")
            {
                strId = strId.TrimEnd(new char[] { ',' });
                IHelpCenter RHelp = new RHelpCenter();
                int m = RHelp.Delete(strId);
                Bind();
            }
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }
    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
        {
            return Convert.ToDateTime(dateStr).ToShortDateString();
        }
        else
            return string.Empty;
    }
    protected void gvHelpCenter_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        try
        {
            int id = int.Parse(gvHelpCenter.DataKeys[e.RowIndex]["ID"].ToString());
            IHelpCenter RHelp = new RHelpCenter();
            int m = RHelp.Delete(id);
            Bind();
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }
    protected void gvHelpCenter_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
        }
    }
}
