﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Help;
using SqlOperate;

public partial class admin_Help_HelpTypeList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "D1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    int ParentID = 0;
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        string strWhere = "1=1";
        PageNo1.Strurl = strURl;
        PageNo1.FldName = "a.ID";
        PageNo1.Table = "W_HelpType a";
        PageNo1.StrGetFields = "a.ID,a.Name,a.ParentID,(select count(*) from W_HelpType where ParentID=a.ID) as time";
        PageNo1.PageSize = 12;
        if (Request.QueryString["ParentId"] != null && Request.QueryString["ParentId"] != "")
        {
            ParentID = int.Parse(Request.QueryString["ParentId"]);
        }
        strWhere += " AND ParentID=" + ParentID;
        DataTable dt = new DataTable();
        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
        {
            PageNo1.Pageindex = Int32.Parse(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            dt = PageNo1.BindViewDesc();
            if (dt.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
                return;
            }
            gvHelpTypeList.DataSource = dt.DefaultView;
            gvHelpTypeList.DataBind();
        }
        else
        {
            PageNo1.Pageindex = 1;
            Session["strWhere"] = strWhere;
            PageNo1.Where = strWhere;
            dt = PageNo1.BindViewDesc();
            if (dt.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
                return;
            }
            gvHelpTypeList.DataSource = dt.DefaultView;
            gvHelpTypeList.DataBind();
        }
        dt.Clear();
        dt.Dispose();
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (txtType.Text == string.Empty)
        {
            Response.Write("<script>alert('信息类别不能为空！')</script>");
            return;
        }
        int id = 0;
        if (Request.QueryString["ParentID"] != null && Request.QueryString["ParentID"] != "")
            id = int.Parse(Request.QueryString["ParentID"].ToString());
        IHelpType RHelp = new RHelpType();
        THelpType THelp = new THelpType();
        THelp.ParentID = id;
        THelp.Name = txtType.Text.Trim();
        try
        {
            RHelp.Insert(THelp);
            Bind();
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }


    protected void btnCancel_Click(object sender, EventArgs e)
    {
        this.txtType.Text = string.Empty;
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        try
        {
            string strId="";
            for (int i = 0; i < gvHelpTypeList.Rows.Count; i++)
            {
                CheckBox chk = (CheckBox)gvHelpTypeList.Rows[i].FindControl("CheckBox1");
                if (chk.Checked == true)
                {
                    strId +=gvHelpTypeList.DataKeys[i]["ID"].ToString()+",";                   
                }
            }
            if (strId != "")
            {
                strId = strId.TrimEnd(new char[] { ',' });
                IHelpType RHelp = new RHelpType();
                RHelp.Delete(strId);
                RHelp.DeleteParentID(strId);
                Bind();
            }
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }
    protected void gvHelpTypeList_RowEditing(object sender, GridViewEditEventArgs e)
    {
        gvHelpTypeList.EditIndex = e.NewEditIndex;
        Bind();
    }
    protected void gvHelpTypeList_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        try
        {
            int id = int.Parse(gvHelpTypeList.DataKeys[e.RowIndex]["ID"].ToString());
            string name = ((TextBox)gvHelpTypeList.Rows[e.RowIndex].FindControl("txtName")).Text;
            THelpType THelp = new THelpType();
            THelp.ID = id;
            THelp.Name = name;
            IHelpType RHelp = new RHelpType();
            RHelp.update(THelp);
            gvHelpTypeList.EditIndex = -1;
            Bind();
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }
    protected void gvHelpTypeList_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        gvHelpTypeList.EditIndex = -1;
        Bind();
    }
    protected void gvHelpTypeList_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        try
        {
            int id = int.Parse(gvHelpTypeList.DataKeys[e.RowIndex]["ID"].ToString());
            IHelpType RHelp = new RHelpType();
            RHelp.Delete(id);
            RHelp.DeleteParentID(id.ToString());
            Bind();
            Response.Redirect("HelpTypeList.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }
    public bool IsCount(string s)
    {
        if (!s.Equals("0"))
        {
            return true;
        }
        else
            return false;
    }   
    protected void lbtnBack_Click(object sender, EventArgs e)
    {
        Response.Redirect("HelpTypeList.aspx");
    }
    protected void gvHelpTypeList_RowCreated(object sender, GridViewRowEventArgs e)
    {
        if (Request["ParentId"] != null && Request["ParentId"] != "")
        {
            HyperLink hlkName = e.Row.Cells[1].FindControl("hlkAdd") as HyperLink;
            if (hlkName != null)
            {
                hlkName.Enabled = false;
            }

        }
    }
    protected void gvHelpTypeList_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
        }
    }
}