﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspJob;
using Base;

public partial class Member_Job_JobEdit : BasePage
{
    string age = "";
    DataTable table = null;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (CheckRights("Basic", "A1"))
        {
            if (!IsPostBack)
            {
                //判断是否有权限
                BindPosition();
                Bind();
            }
        }

    }

    ///**************************************************
    /// <summary>
    /// depiction：对职位类别绑定
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-2
    ///**************************************************
    private void BindPosition()
    {
        Rjob jobtype = new Rjob();
        DataTable dt = jobtype.GetDataType("C_JobType");
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataTextField = "TypeName";
        dropTypeID.DataBind();
    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法用于获取页面传过来的值、然后绑定控件。
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-2
    ///**************************************************
    public void Bind()
    {
        string id = "";
        string age1 = "";
        string age2 = "";
        if (Request.QueryString["jobid"] != null)
        {
            id = Request["jobid"];
        }
        IJob ijob = new Rjob();
        table = ijob.GetDataTableByWhere(Convert.ToInt32(id));
        if (table.Rows.Count != 0)
        {
            this.dropTypeID.SelectedValue = table.Rows[0]["TypeID"].ToString().Trim();
            this.txtposition.Text = table.Rows[0]["Position"].ToString().Trim();
            this.txtcount.Text = table.Rows[0]["Count"].ToString().Trim();
            this.txteducation.SelectedValue = table.Rows[0]["Degree"].ToString().Trim();
            age = table.Rows[0]["AgeRequest"].ToString().Trim();
            age1 = age.Substring(0, age.LastIndexOf('~'));
            age2 = age.Substring(age.LastIndexOf('~') + 1);
            this.txtage1.Text = age1;
            this.txtage2.Text = age2;
            this.txtwork.Text = table.Rows[0]["Experience"].ToString().Trim();
            this.txtTemper.Text = table.Rows[0]["WorkTemper"].ToString().Trim();
            this.txtaddress.Text = table.Rows[0]["Address"].ToString().Trim();
            this.dropsalary.SelectedValue = table.Rows[0]["SalaryLevel"].ToString().Trim();
            this.dropsex.SelectedValue = table.Rows[0]["Sex"].ToString().Trim();
            this.dropEnlish.SelectedValue = table.Rows[0]["EnglishLevel"].ToString().Trim();
            this.dropcomputer.SelectedValue = table.Rows[0]["ComputerLevel"].ToString().Trim();
            this.txtenddate.Text = GetShortDate(table.Rows[0]["EndDate"].ToString().Trim());
        }
    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法用于更新数据
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-2
    ///**************************************************

    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (!this.IsValid)
        {
            return;
        }
        try
        {
            string id = "";
            if (Request.QueryString["jobid"] != null)
            {
                id = Request["jobid"];
            }
            TJob tj = new TJob();
            IJob ij = new Rjob();
            tj.ID = Convert.ToInt32(id);
            tj.TypeID = Convert.ToInt32(this.dropTypeID.SelectedValue);
            tj.Position = this.txtposition.Text;
            tj.JobCount = Convert.ToInt32(this.txtcount.Text);
            tj.Degree = this.txteducation.SelectedValue;
            tj.AgeRequest = this.txtage1.Text + "~" + this.txtage2.Text;
            if (Convert.ToInt32(this.txtage1.Text) >= Convert.ToInt32(this.txtage2.Text))
            {
                lblmessage.Text = "起始年龄不能大于终止年龄";
                return;
            }
            tj.Experience = this.txtwork.Text;
            tj.WorkTemper = this.txtTemper.Text;
            tj.Address = this.txtaddress.Text;
            tj.SalaryLevel = this.dropsalary.SelectedValue;
            tj.Sex = this.dropsex.SelectedValue;
            tj.EnglishLevel = this.dropEnlish.SelectedValue;
            tj.ComputerLevel = this.dropcomputer.SelectedValue;
            DateTime dt1 = Convert.ToDateTime(txtenddate.Text.ToString());
            DateTime dt2 = Convert.ToDateTime(DateTime.Now.ToLongDateString());
            if (dt1 < dt2)
            {
                Lblmsgtime.Text = "截止日期不能小于当前日期";
                return;
            }
            tj.EndDate = Convert.ToDateTime(GetShortDate(this.txtenddate.Text));
            int count = ij.Update(tj);
            if (count > 0)
            {
                //页面跳转
                ShowMessage("恭喜您，职位信息修改成功！", "Job/ManagerJobList.aspx?class=MenuLiCheck");
            }
        }
        catch (Exception error)
        {
           
        }
    }
    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }
    //对企业发布职位取消操作
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("~/Admin/Job/ManagerJobList.aspx");
    }
}
