﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspJob;
using Base;

public partial class Admin_Job_JobManager : BasePage
{
    string strWhere = " 1=1";
    DataTable dt = new DataTable();
    protected void Page_Load(object sender, EventArgs e)
    {
        //判断用户时候有权限
       if (CheckRights("Basic", "A1"))
        {
            if (!IsPostBack)
            {
                PositionTypeBind();//绑定职位类别
                Bind();//绑定数据  
            }
        }

    }
    ///**************************************************
    /// <summary>
    /// depiction：此方法用于绑定数据
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-3
    ///**************************************************
    private void Bind()
    {
        int PageIndex = 0;
        if (HttpContext.Current.Request.QueryString["page"] != null)
            PageIndex = Convert.ToInt32(Request.QueryString["Page"].ToString());
        if (PageIndex <= 0) PageIndex = 1;
        if (Base.GetRequest.CheckQueryStringisInt("verify"))
        {
            if (Request.QueryString["Verify"] == "3")//未审核
            {
                strWhere += " and a.verify =3 or a.verify =2";
            }
            else if (Request.QueryString["Verify"] == "1")//审核
            {
                strWhere += " and a.verify =1 ";

            }
            else if (Request.QueryString["Verify"] == "2")//推荐
            {
                strWhere += " and a.isRecommend =1";

            }
            else
            {
                strWhere += " and a.typeid =";
                strWhere += this.HiddenField1.Value;
            }

        }
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        PageNo1.FldName = "a.AddDate";
        PageNo1.Table = " U_UserInfo b inner join C_Job a on(b.UserID=a.UserID) ";
        PageNo1.StrGetFields = "a.*,b.UserID,b.CompanyName";
        PageNo1.PageSize = 12;

        if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Int32.Parse(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            dt = PageNo1.BindViewDesc();
        }
        else
        {
            PageNo1.Pageindex = 1;
            PageNo1.Where = strWhere;
            Session["strWhere"] = strWhere;
            dt = PageNo1.BindViewDesc();
        }
        if (dt.Rows.Count == 0)
        {
            grdJob.DataSource = dt.DefaultView;
            grdJob.DataBind();
            dt.Clear();
            dt.Dispose();
            SetColor();
        }
        else
        {
            grdJob.DataSource = dt.DefaultView;
            grdJob.DataBind();
            dt.Clear();
            dt.Dispose();
            SetColor();
        }

    }
    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }
    ///**************************************************
    /// <summary>
    /// depiction：此方法用于对职位是否通过审核赋值
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-3
    ///**************************************************
    public string turncn(int tmp)
    {
        string Str = "审核";
        if (tmp == 3)
            Str = "未审核";
        if (tmp == 2)
            Str = "未通过";
        return Str;
    }
    ///**************************************************
    /// <summary>
    /// depiction：此方法用于对职位是否通过推荐
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Writer：冯新华
    ///Create Date：2009-9-3
    ///**************************************************
    public string recommend(bool tmp)
    {
        string Str = "推荐";
        if (!tmp)
            Str = "未推荐";
        return Str;
    }
    ///**************************************************
    /// <summary>
    /// depiction：<对该方法的说明>
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-3
    ///**************************************************
    private void SetColor()
    {
        if (Request.QueryString["Verify"] != null)
        {
            if (Request.QueryString["Verify"] == "0")
                this.Label5.Attributes.Add("class", "MenuLiCheck");
            else if (Request.QueryString["Verify"] == "2")
                this.Label3.Attributes.Add("class", "MenuLiCheck");
            else if (Request.QueryString["Verify"] == "3")
                this.Label1.Attributes.Add("class", "MenuLiCheck");
            else
                this.Label2.Attributes.Add("class", "MenuLiCheck");
        }
        else
        {
            this.Label5.Attributes.Add("class", "MenuLiCheck");
        }

    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法用于单个删除
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-3
    ///**************************************************
    protected void grdJob_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = Convert.ToInt32(grdJob.DataKeys[e.RowIndex].Value);
        IJob ijob = new Rjob();
        ijob.Delete(" C_JobResume", id,"id");
        ijob.Delete("C_Job", id,"id");
        Bind();
    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法用于批量删除
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-2
    ///**************************************************
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < grdJob.Rows.Count; i++)
        {
            CheckBox cbox = grdJob.Rows[i].FindControl("CheckBox1") as CheckBox;
            if (cbox.Checked == true)
            {
                int id = int.Parse(grdJob.DataKeys[i].Value.ToString());
                IJob ijob = new Rjob();
                ijob.Delete(" C_JobResume", id,"id");
                ijob.Delete("C_Job", id,"id");
            }
        }
        Bind();
    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法用于批量审核通过
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-8-31
    ///**************************************************
    protected void ButEigible_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdJob.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdJob.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += "," + Convert.ToInt32(grdJob.DataKeys[i].Value);
            }
        }

        if (Solely.Other.UpOnlyDate("C_Job", "Verify=1", "id in(" + strID.Substring(1) + ")"))
        {
            Bind();

        }

    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法用于批量审核未通过
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-8-31
    ///**************************************************
    protected void ButDisqualification_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdJob.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdJob.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += "," + Convert.ToInt32(grdJob.DataKeys[i].Value);
            }
        }

        if (Solely.Other.UpOnlyDate("C_Job", "Verify=2", "id in(" + strID.Substring(1) + ")"))
        {

            Bind();
        }

    }
    protected void grdJob_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this);");
        }
        showToolTip(e);
    }
    ///**************************************************
    /// <summary>
    /// depiction：对职位类别绑定
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-1
    ///**************************************************
    private void PositionTypeBind()
    {

        Rjob jobtype = new Rjob();
        DataTable dt = jobtype.GetDataType("C_JobType");
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataTextField = "TypeName";
        dropTypeID.DataBind();

        dropTypeID.Items.Insert(0, new ListItem("全部", "0"));


    }
    ///**************************************************
    /// <summary>
    /// depiction：此方法用于查询
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-2
    ///**************************************************
    protected void btnSelect_Click(object sender, EventArgs e)
    {
        string positionName = this.txtpostion.Text.Trim();
        string companyName = this.txtcompany.Text.Trim();
        string positonType = dropTypeID.SelectedValue.ToString();
        if (!string.IsNullOrEmpty(positionName))
        {
            strWhere += " and  a.Position like '%" + Base.GetRequest.Filter(positionName) + "%'";
        }
        if (!string.IsNullOrEmpty(companyName))
        {
            strWhere += " and  b.CompanyName like '%" + Base.GetRequest.Filter(companyName) + "%'";
        }
        if (!positonType.Equals("0"))
        {
            strWhere += " and a.TypeID =" + positonType + "";

        }
        Session["strWhere"] = strWhere;
        Bind();
    }
    ///**************************************************
    /// <summary>
    /// depiction：此方法用于推荐
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-2
    ///**************************************************
    protected void BtnRecord_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdJob.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdJob.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += "," + Convert.ToInt32(grdJob.DataKeys[i].Value);
            }
        }

        if (Solely.Other.UpOnlyDate("C_Job", "isRecommend=1", "id in(" + strID.Substring(1) + ")"))
        {

            Bind();
        }
    }
    protected void dropTypeID_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.HiddenField1.Value = this.dropTypeID.SelectedValue;
    }
    ///**************************************************
    /// <summary>
    /// depiction：此方法用于显示小提示
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-2
    ///**************************************************
    private static void showToolTip(GridViewRowEventArgs e)
    {
        string position = Convert.ToString(DataBinder.Eval(e.Row.DataItem, "CompanyName"));
        string adddate = Convert.ToString(DataBinder.Eval(e.Row.DataItem, "AddDate"));
        string enddate = Convert.ToString(DataBinder.Eval(e.Row.DataItem, "EndDate"));
        string positionName = Convert.ToString(DataBinder.Eval(e.Row.DataItem, "Position"));
        string positiontype = Convert.ToString(DataBinder.Eval(e.Row.DataItem, "Position"));
        e.Row.ToolTip = "公司名称：" + position + "\n职位名称：" + positionName + "\n发布时间：" + adddate + "\n截止时间：" + enddate;
    }
    /// <summary>
    /// 取消推荐
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Button1_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdJob.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdJob.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += "," + Convert.ToInt32(grdJob.DataKeys[i].Value);
            }
        }

        if (Solely.Other.UpOnlyDate("C_Job", "isRecommend=0", "id in(" + strID.Substring(1) + ")"))
        {

            Bind();
        }
    }
}
