﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using nspJob;


public partial class Admin_Job_JobTypeManager : BasePage
{
    string strWhere = " 1=1 ";
    DataTable tbJobtype = new DataTable();
    IJob ijob = new Rjob();
    protected void Page_Load(object sender, EventArgs e)
    {

        ///**************************************************
        /// <summary>
        /// depiction：该方法对用户权限进行检测，只有管理员拥有该权限
        /// </summary>
        /// <param name="<参数名称>"><参数说明></param>
        /// <returns>
        ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
        /// </returns>
        ///Create Date：2009-8-29
        ///**************************************************
         if (CheckRights("Basic", "A1"))
        {
            if (!IsPostBack)
            {
                Bind();
            }
        }
    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法用于绑定datalist
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-8-29
    ///**************************************************
    private void Bind()
    {
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        PageNo1.Table = "C_JobType";
        PageNo1.FldName = "AddDate";
        PageNo1.StrGetFields = "ID,TypeName,AddDate";
        PageNo1.PageSize = 12;
        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            tbJobtype = PageNo1.BindViewDesc();
        }
        else
        {
            PageNo1.Pageindex = 1;
            PageNo1.Where = strWhere;
            Session["strWhere"] = strWhere;
            tbJobtype = PageNo1.BindViewDesc();
        }
        if (tbJobtype.Rows.Count == 0)
        {
            dlstProType.DataSource = tbJobtype.DefaultView;
            dlstProType.DataBind();
            tbJobtype.Clear();
            tbJobtype.Dispose();
        }
        else
        {

            dlstProType.DataSource = tbJobtype.DefaultView;
            dlstProType.DataBind();
            tbJobtype.Clear();
            tbJobtype.Dispose();
        }


    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法是取消对职位类别的修改
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-8-29
    ///**************************************************
    protected void dlstProType_CancelCommand(object source, DataListCommandEventArgs e)
    {
        dlstProType.EditItemIndex = -1;
        Bind();
    }
    ///**************************************************
    /// <summary>
    /// depiction：此方法是对职位类别的删除
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-8-29
    ///**************************************************
    protected void dlstProType_DeleteCommand(object source, DataListCommandEventArgs e)
    {
        int id = Convert.ToInt32(dlstProType.DataKeys[e.Item.ItemIndex]);
        TJobType TProType = new TJobType();
        IJobType IProType = new RJobType();
        TProType.ID = id;
        IProType.Delete(id);
       // ijob.Delete("U_Resume", id, "TalentType");
        ijob.Delete("C_Job", id, "TypeID");
        Bind();
    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法是对职位类别的编辑
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-8-29
    ///**************************************************
    protected void dlstProType_EditCommand(object source, DataListCommandEventArgs e)
    {
        dlstProType.EditItemIndex = e.Item.ItemIndex;
        Bind();
    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法是对职位类别的修改
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-8-29
    ///**************************************************
    protected void dlstProType_UpdateCommand(object source, DataListCommandEventArgs e)
    {
        int id = Convert.ToInt32(dlstProType.DataKeys[e.Item.ItemIndex]);
        string name = ((TextBox)e.Item.FindControl("txtName")).Text;
        TJobType TProType = new TJobType();
        TProType.ID = id;
        TProType.TypeName = name;
        IJobType IProType = new RJobType();
        IProType.Update(TProType);
        dlstProType.EditItemIndex = -1;
        Bind();
    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法是对职位类别名称查询
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-8-29
    ///**************************************************
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        string uName = txtName.Text.Trim();
        if (uName.Trim() != "")
        {
            strWhere += " and  TypeName  like  '%" + Base.GetRequest.Filter(uName) + "%'";
            Session["strWhere"] = strWhere;
        }
        Bind();
    }

    ///**************************************************
    /// <summary>
    /// depiction：该方法是对添加区域span标记的 显示跟隐藏
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-8-29
    ///**************************************************
    protected void LinkButton1_Click(object sender, EventArgs e)
    {
        if (pnlArea.Visible)
        {
            pnlArea.Visible = false;
        }
        else
        {
            pnlArea.Visible = true;
        }
    }
    ///**************************************************
    /// <summary>
    /// depiction：该方法是用于取消对职位类别的添加的
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-8-29
    ///**************************************************
    protected void btnReturn_Click(object sender, EventArgs e)
    {
        pnlArea.Visible = false;
    }

    ///**************************************************
    /// <summary>
    /// depiction：该方法用于对数据批量删除
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-8-29
    ///**************************************************
    protected void btnDelete_Click1(object sender, EventArgs e)
    {
        for (int i = 0; i <= dlstProType.Items.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)dlstProType.Items[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {

                int id = Convert.ToInt32(dlstProType.DataKeys[i]);
                RJobType rjobtype = new RJobType();
                rjobtype.Delete(id);
                ijob.Delete("U_Resume", id, "TalentType");
                ijob.Delete("C_Job", id, "TypeID");
            }
        }

        Bind();
    }

    protected void txtTypeName_TextChanged(object sender, EventArgs e)
    {
        IJobType IPro = new RJobType();//调用职位类别的实现类
        bool result = IPro.GetDataExists(txtTypeName.Text);

        if (result)
        {
            lblMessage.Text = "该类别已存在，请更换类别！";
        }
        else
        {
            lblMessage.Text = "";
        }

    }
    ///**************************************************
    /// <summary>
    /// depiction：该方法是用于添加职位类别的
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-8-29
    ///**************************************************
    protected void btnInsert_Click(object sender, EventArgs e)
    {
        try
        {
            IJobType IPro = new RJobType();//调用职位类别的实现类
            TJobType tp = new TJobType();
            //判断职位类别是否存在
            String TypeName = this.txtTypeName.Text;
            bool result = IPro.GetDataExists(TypeName);
            if (result)
            {
                lblMessage.Text = "该类别已存在，请更换类别！";
                this.txtTypeName.Text = "";
            }
            else
            {
                //如果不存在则添加
                if (!string.IsNullOrEmpty(TypeName.Trim()))
                {
                    tp.TypeName = TypeName;
                    IPro.Insert(tp);
                    this.txtTypeName.Text = "";
                    Bind();
                    lblMessage.Text = "添加成功";

                }
                else
                {
                    lblMessage.Text = "请输入职位类别名称！";

                }

            }

            //如果添加失败
        }
        catch (Exception ex)
        {
            lblMessage.Text = "添加失败！";
            // Base.BasePage.ShowMessage("职位类别添加失败!", "Job/JobTypeManager.aspx");
        }
    }
}
