﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using nspJob;
using Base;

public partial class Admin_Job_ManagerResumeEdit : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        //判断是否有权限，以及用户是否登陆如果不是跳转页面
        if (CheckRights("Basic", "A1"))
        {
            if (!IsPostBack)
            {

                PositionTypeBind();
                Bind();
            }
        }
    }
    ///**************************************************
    /// <summary>
    /// depiction：对职位类别绑定
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-1
    ///**************************************************
    private void PositionTypeBind()
    {

        Rjob jobtype = new Rjob();
        DataTable dt = jobtype.GetDataType("C_JobType");
        DrpTypePosition.DataSource = dt.DefaultView;
        DrpTypePosition.DataValueField = "ID";
        DrpTypePosition.DataTextField = "TypeName";
        DrpTypePosition.DataBind();
    }
    public void Bind()
    {
        string id = "";
        if (Request.QueryString["ID"] != null)
        {
            id = Request["id"];
        }
        RResume re = new RResume();
        DataTable table = re.GetDataTableByWhere(id);
        if (null != table)
        {
            this.txtPosition.Text = table.Rows[0]["WantPosition"].ToString();
            this.ImgUrl1.Value = table.Rows[0]["Photo"].ToString();
            this.ImgUrl.Src = table.Rows[0]["Photo"].ToString();
            this.DrpSex.SelectedValue = table.Rows[0]["Sex"].ToString();
            this.txteducation.SelectedValue = table.Rows[0]["HighestEducation"].ToString();
            this.txtGraduteSchool.Text = table.Rows[0]["GraduateSchool"].ToString();
            this.txtNative.Text = table.Rows[0]["NativePlace"].ToString();
            this.txtWantAddress.Text = table.Rows[0]["WantAddress"].ToString();
            this.DrpTypePosition.SelectedValue = table.Rows[0]["TalentType"].ToString();
            this.txtAge.Text = Convert.ToDateTime(table.Rows[0]["DateofBirth"].ToString()).ToShortDateString();
            this.Radhunyin.SelectedValue = table.Rows[0]["MaritalStatus"].ToString();
            this.dropcomputer.SelectedValue = table.Rows[0]["ComputerRequest"].ToString();
            this.dropEnlish.SelectedValue = table.Rows[0]["EnglishRequest"].ToString();
            this.txtDescription.Text = table.Rows[0]["JobDescription"].ToString();
            this.txtPersonResum.Text = table.Rows[0]["PersResume"].ToString();
            this.dropsalary.SelectedValue = table.Rows[0]["WantSalary"].ToString();
            this.txtName.Text = table.Rows[0]["Name"].ToString();
            this.txtTelphone.Text = table.Rows[0]["Telephone"].ToString();
            this.txtEmail.Text = table.Rows[0]["Email"].ToString();
            this.txtQQ.Text = table.Rows[0]["QQ"].ToString();
            this.txtMobel.Text = table.Rows[0]["Mobile"].ToString();
            this.txtAddress.Text = table.Rows[0]["ContactAddress"].ToString();
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (!this.IsValid)
        {
            return;
        }
        TResume tr = new TResume();
        RResume re = new RResume();
        try
        {
            string id = "";
            if (Request.QueryString["ID"] != null)
            {
                id = Request["id"];
                tr.ID = Convert.ToInt32(id);
            }

            tr.WantPosition = this.txtPosition.Text;
            tr.Photo = ImgUrl1.Value;
            tr.DateofBirth = Convert.ToDateTime(this.txtAge.Text.ToString());
            tr.GraduateSchool = this.txtGraduteSchool.Text;
            tr.WantAddress = this.txtWantAddress.Text;
            tr.JobDescription = GetRequest.RemoveHTMLForEditor(this.txtDescription.Text);
            tr.NativePlace = txtNative.Text;
            tr.PersResume = GetRequest.RemoveHTMLForEditor(this.txtPersonResum.Text);
            tr.Name = this.txtName.Text;
            tr.QQ = this.txtQQ.Text;
            tr.Telephone = this.txtTelphone.Text;
            tr.Mobile = this.txtMobel.Text;
            tr.Email = this.txtEmail.Text;
            tr.ContactAddress = this.txtAddress.Text;
            tr.Txtwork = dropwork.SelectedValue;
            tr.MaritalStatus = Radhunyin.SelectedValue;
            tr.Sex = DrpSex.SelectedValue;
            tr.HighestEducation = txteducation.SelectedValue;
            tr.ComputerRequest = dropcomputer.SelectedValue;
            tr.EnglishRequest = dropEnlish.SelectedValue;
            tr.TalentType = DrpTypePosition.SelectedValue;
            tr.WantSalary = dropsalary.SelectedValue;
            int count = re.Update(tr);//添加简历
            if (count > 0)
            {
                ShowMessage("恭喜您,简历信息修改成功！", "Job/ManagerResumeList.aspx?class=MenuLiCheck");
            }
        }
        catch (Exception error)
        {
            Response.Write(error.Message); //异常处理页面跳转
        }

    }
    //对会员简历取消操作
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>location.assign('/Admin/Job/ManagerResumeList.aspx');</script>");
    }
}
