﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspJob;
using Base;

public partial class Admin_Job_ManagerResumeList : BasePage
{
    string strWhere = " 1=1 ";
    DataTable dt = new DataTable();
    protected void Page_Load(object sender, EventArgs e)
    {
        //判断用户时候有权限
        if (CheckRights("Basic", "A1"))
        {
            if (!IsPostBack)
            {
                PositionTypeBind();//绑定职位类别
                Bind();//绑定数据
            }
        }
    }
    ///**************************************************
    /// <summary>
    /// depiction：此方法用于绑定数据 
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-3
    ///**************************************************
    private void Bind()
    {
        int PageIndex = 0;
        if (HttpContext.Current.Request.QueryString["page"] != null)
            PageIndex = Convert.ToInt32(Request.QueryString["Page"].ToString());
        if (PageIndex <= 0) PageIndex = 1;
        if (Base.GetRequest.CheckQueryStringisInt("verify"))
        {
            if (Request.QueryString["Verify"] == "3")//未审核
            {
                strWhere += " and a.verify =3 or a.verify =2";

            }
            else if (Request.QueryString["Verify"] == "1")//审核
            {
                strWhere += " and a.verify =1  ";

            }
            else if (Request.QueryString["Verify"] == "2")//推荐
            {
                strWhere += " and a.isRecommend =1";

            }
            else
            {
                strWhere += " and a.typeid =";
                strWhere += this.HiddenField1.Value;
            }

        }

        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        PageNo1.FldName = " a.AddDate";
        PageNo1.Table = "U_Resume a left join U_Applicant b on(a.id=b.ResumeID)";
        PageNo1.StrGetFields = "a.*,b.ID,b.ResumeID,b.LoginName";
        PageNo1.PageSize = 12;
        if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Int32.Parse(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            dt = PageNo1.BindViewDesc();
        }
        else
        {
            PageNo1.Pageindex = 1;
            PageNo1.Where = strWhere;
            Session["strWhere"] = strWhere;
            dt = PageNo1.BindViewDesc();
        }
        if (dt.Rows.Count == 0)
        {
            grdJob.DataSource = dt.DefaultView;
            grdJob.DataBind();
            dt.Clear();
            dt.Dispose();
            SetColor();
        }
        else
        {
            grdJob.DataSource = dt.DefaultView;
            grdJob.DataBind();
            dt.Clear();
            dt.Dispose();
            SetColor();
        }

    }
    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }
    ///**************************************************
    /// <summary>
    /// depiction：此方法用于对职位是否通过审核赋值
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-3
    ///**************************************************
    public string turncn(int tmp)
    {
        string Str = "审核";
        if (tmp == 3)
            Str = "未审核";
        if (tmp == 2)
            Str = "未通过";
        return Str;
    }
    ///**************************************************
    /// <summary>
    /// depiction：此方法用于对简历是否通过推荐
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-3
    ///**************************************************
    public string recommend(bool tmp)
    {
        string Str = "推荐";
        if (!tmp)
            Str = "未推荐";
        return Str;
    }
    ///**************************************************
    /// <summary>
    /// depiction：此方法用于对简历是否发布
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-3
    ///**************************************************
    public string RelaseState(bool tmp)
    {
        string Str = "暂停";
        if (tmp)
            Str = "发布";
        return Str;
    }
    ///**************************************************
    /// <summary>
    /// depiction：<对该方法的说明>
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-3
    ///**************************************************
    private void SetColor()
    {
        if (Request.QueryString["Verify"] != null)
        {
            if (Request.QueryString["Verify"] == "0")
                this.Label5.Attributes.Add("class", "pl");
            else if (Request.QueryString["Verify"] == "2")
                this.Label3.Attributes.Add("class", "pl");
            else if (Request.QueryString["Verify"] == "3")
                this.Label1.Attributes.Add("class", "pl");
            else
                this.Label2.Attributes.Add("class", "pl");
        }
        else
        {
            this.Label5.Attributes.Add("class", "pl");
        }

    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法用于单个删除
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-3
    ///**************************************************
    protected void grdJob_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int ID = Convert.ToInt32(grdJob.DataKeys[e.RowIndex].Value);
        IResume rm = new RResume();
        rm.Delete(ID);
        Bind();
    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法用于批量删除
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-2
    ///**************************************************
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < grdJob.Rows.Count; i++)
        {
            CheckBox cbox = grdJob.Rows[i].FindControl("CheckBox1") as CheckBox;
            if (cbox.Checked == true)
            {
                int id = int.Parse(grdJob.DataKeys[i].Value.ToString());
                IResume rm = new RResume();
                rm.Delete(id);
            }
        }
        Bind();
    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法用于批量审核通过
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-8-31
    ///**************************************************
    protected void ButEigible_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdJob.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdJob.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += "," + Convert.ToInt32(grdJob.DataKeys[i].Value);
            }
        }

        if (Solely.Other.UpOnlyDate("U_Resume", "Verify=1", "id in(" + strID.Substring(1) + ")"))
        {
            Bind();

        }

    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法用于批量审核未通过
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-8-31
    ///**************************************************
    protected void ButDisqualification_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdJob.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdJob.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += "," + Convert.ToInt32(grdJob.DataKeys[i].Value);
            }
        }

        if (Solely.Other.UpOnlyDate("U_Resume", "Verify=2", "id in(" + strID.Substring(1) + ")"))
        {

            Bind();
        }

    }
    protected void grdJob_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this);");
        }
        showToolTip(e);
    }
    ///**************************************************
    /// <summary>
    /// depiction：对职位类别绑定
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-1
    ///**************************************************
    private void PositionTypeBind()
    {

        Rjob jobtype = new Rjob();
        DataTable dt = jobtype.GetDataType("C_JobType");
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataValueField = "id";
        dropTypeID.DataTextField = "TypeName";
        dropTypeID.DataBind();

        dropTypeID.Items.Insert(0, new ListItem("全部", "0"));



    }
    ///**************************************************
    /// <summary>
    /// depiction：此方法用于查询
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-2
    ///**************************************************
    protected void btnSelect_Click(object sender, EventArgs e)
    {
        string name = this.txtName.Text;
        string positonType = dropTypeID.SelectedItem.Value.ToString();
        if (!string.IsNullOrEmpty(name))
        {
            strWhere += "  and a.Name like '%" + Base.GetRequest.Filter(name) + "%'";
        }
        if (!positonType.Equals("0"))
        {
            strWhere += " and a.TalentType =" + Base.GetRequest.Filter(positonType) + "";
        }
        Session["strWhere"] = strWhere;
        Bind();
    }
    ///**************************************************
    /// <summary>
    /// depiction：此方法用于推荐
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-2
    ///**************************************************
    protected void BtnRecord_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdJob.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdJob.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += "," + Convert.ToInt32(grdJob.DataKeys[i].Value);
            }
        }

        if (Solely.Other.UpOnlyDate("U_Resume", "isRecommend=1", "id in(" + strID.Substring(1) + ")"))
        {

            Bind();
        }
    }
    protected void dropTypeID_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.HiddenField1.Value = this.dropTypeID.SelectedValue;
    }
    ///**************************************************
    /// <summary>
    /// depiction：此方法用于显示小提示
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-2
    ///**************************************************
    private static void showToolTip(GridViewRowEventArgs e)
    {
        RJobType rj = new RJobType();
        string name = Convert.ToString(DataBinder.Eval(e.Row.DataItem, "Name"));
        string highschool = Convert.ToString(DataBinder.Eval(e.Row.DataItem, "HighestEducation"));
        string talenttype = rj.GetDataTableByWhere(Convert.ToInt32(DataBinder.Eval(e.Row.DataItem, "TalentType")));
        string registerTime = Convert.ToString(DataBinder.Eval(e.Row.DataItem, "AddDate"));
        e.Row.ToolTip = "姓名：" + name + "\n最高学历：" + highschool + "\n人才类型：" + talenttype.ToString() + "\n登记时间：" + registerTime;
    }

    ///**************************************************
    /// <summary>
    /// depiction：根据职位类型id得到职位名称
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-4
    ///**************************************************
    public string getNameById(int id)
    {
        RJobType rj = new RJobType();
        string TypeName = rj.GetDataTableByWhere(id);
        return TypeName;
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdJob.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdJob.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += "," + Convert.ToInt32(grdJob.DataKeys[i].Value);
            }
        }

        if (Solely.Other.UpOnlyDate("U_Resume", "isRecommend=0", "id in(" + strID.Substring(1) + ")"))
        {

            Bind();
        }
    }
}
