﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Keywords;

public partial class admin_Keywords_KeywordsEdit : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Basic", "A1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        if (Request.QueryString["ID"].ToString()!= null && Request.QueryString["ID"].ToString() != "")
        {
            int id = Convert.ToInt32(Request.QueryString["ID"].ToString());
            IKeywords RKey = new RKeywords();
            TKeywords TKey = RKey.GateItem(id);
            lblType.Text = GetType(TKey.Type);
            txtName.Text = TKey.Name;
            txtCount.Text = TKey.Count.ToString();
            radlIsCommend.SelectedValue = TKey.IsCommend.ToString();
        }
    }
    public string GetType(string type)
    {
        if (type != string.Empty)
        {
            if (type == "Supply")
                return "供应信息";
            else if (type == "Purchase")
                return "求购信息";
            else if (type == "SincereAgent")
                return "招商加盟";
            else if (type == "Expo")
                return "展会";
            else if (type == "ExpoNews")
                return "展会资讯";
            else if (type == "Company")
                return "公司";
            else
                return "其他";
        }
        else
            return string.Empty;
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {

        try
        {
            if (Request.QueryString["ID"].ToString() != null && Request.QueryString["ID"].ToString() != "")
            {
                int id = Convert.ToInt32(Request.QueryString["ID"].ToString());
                TKeywords TKeyword = new TKeywords();
                TKeyword.ID = id;
                TKeyword.Name = txtName.Text;
                TKeyword.Count = int.Parse(txtCount.Text);
                TKeyword.IsCommend = Convert.ToBoolean(radlIsCommend.SelectedValue);
                TKeyword.EditDate = DateTime.Now;
                IKeywords RKeyword = new RKeywords();
                RKeyword.Update(TKeyword);
                ShowMessage("热门关键字修改成功！", "Keywords/KeywordsList.aspx");
            }
        }
        catch (Exception ex)
        {

            ShowMessage("热门关键字修改失败！", "Keywords/KeywordsList.aspx");
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script language='javascript'>window.location='KeywordsList.aspx'</script>");
    }
}
