﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Keywords;

public partial class admin_Keywords_KeywordsList : BasePage
{
    private int pageSize = 12;//这里设置分页尺寸
    #region
    public int Pageindex
    {
        //页下标属性
        set
        {
            this.ViewState["pgindex"] = value;
        }
        get
        {
            int index = 1;
            object o = this.ViewState["pgindex"];
            if (o != null)
            {
                index = (int)o;
            }
            return index;
        }
    }
    public int PageCount
    {
        //总页数
        set { this.ViewState["pagecount"] = value; }
        get
        {
            int pagecot = 1;
            object od = this.ViewState["pagecount"];
            if (od != null)
            {
                pagecot = (int)od;
            }
            return pagecot;
        }
    }
    #endregion
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights( "Basic", "A1");
        if (!IsPostBack)
        {
            btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
            string strURl = Request.RawUrl;
            strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";          
            string strWhere = "";
            if (Request.QueryString["page"] != null)
            {
                if (Session["strWhere"] != null)
                {
                    strWhere = Session["strWhere"].ToString();
                }
                else {
                    strWhere = "1=1";
                }
                PageNo1.Strurl = strURl;
                PageNo1.FldName = "EditDate";
                PageNo1.Table = "W_Keyword";
                PageNo1.StrGetFields = "*";
                PageNo1.PageSize = pageSize;
                PageNo1.Where = strWhere;
                PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
                DataTable table = PageNo1.BindView();
                if (table.Rows.Count == 0)
                {
                    lblMessage.Visible = true;
                    lblMessage.Text = "<font color='red'>暂无数据！</font>";
                }
                else {
                    lblMessage.Visible = false;
                }
                grdKeywords.DataSource = table.DefaultView;
                grdKeywords.DataBind();
            }
            else {
                strWhere = "1=1";
                PageNo1.Strurl = strURl;
                PageNo1.FldName = "EditDate";
                PageNo1.Table = "W_Keyword";
                PageNo1.StrGetFields = "*";
                PageNo1.PageSize = pageSize;
                Session["strWhere"] = strWhere;
                PageNo1.Where = strWhere;
                PageNo1.Pageindex = 1;
                DataTable table = PageNo1.BindView();
                if (table.Rows.Count == 0)
                {
                    lblMessage.Visible = true;
                    lblMessage.Text = "<font color='red'>暂无数据！</font>";
                }
                else
                {
                    lblMessage.Visible = false;
                }
                grdKeywords.DataSource = table.DefaultView;
                grdKeywords.DataBind();
            }
        }
    }
    
    public string GetType(string type)
    {
        if (type != string.Empty)
        {
            if (type == "Supply")
                return "供应信息";
            else if (type == "Purchase")
                return "求购信息";
            else if (type == "SincereAgent")
                return "招商加盟"; 
            else if (type == "Expo")
                return "展会";
            else if (type == "ExpoNews")
                return "展会资讯";
            else if (type == "Company")
                return "公司";
            else
                return "其他";
        }
        else
            return string.Empty;
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < grdKeywords.Rows.Count; i++)
        {
            CheckBox cbox = (CheckBox)grdKeywords.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int id = int.Parse(grdKeywords.DataKeys[i].Value.ToString());
                IKeywords RKeywords = new RKeywords();
                RKeywords.Delete(id);
            }
        }
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strURl + "?page=1");
        Response.End();
    }
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        string strWhere = "1=1";
        string name =Base.GetRequest.Filter(txtKeyWords.Text.ToString());
        string type = dropType.SelectedValue;
        if (name != "")
            strWhere += " and Name like '%" + name + "%'";
        if (type != "")
            strWhere += " and type='" + type + "'";
        Session["strWhere"] = strWhere;
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strURl+"?page=1");
        Response.End();
    }
    protected void lbtnUpdate_Command(object sender, CommandEventArgs e)
    {
        //更新推荐信息
        string Content = e.CommandArgument.ToString();
        int index = Content.IndexOf("|");
        if (index < -1 || index + 1 > Content.Length)
            return;
        TKeywords TKey = new TKeywords();
        TKey.ID = Convert.ToInt32(Content.Substring(0, index));
        TKey.IsCommend = Convert.ToBoolean(Content.Substring(index + 1));
        IKeywords RKey = new RKeywords();
        RKey.UpdateReCommend(TKey);
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strURl + "?page=1");
        Response.End();
    }
    protected void Keywords_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        grdKeywords.PageIndex = e.NewPageIndex;
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strURl + "?page=1");
        Response.End();
    }
    protected void Keywords_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        //弹出警告对话框
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
            LinkButton btn = (LinkButton)e.Row.FindControl("lbtnUpdate");
            if (btn.Text == "推荐")
                btn.Attributes.Add("onclick", "javascript:return confirm('你确认要取消推荐吗')");
            else
                btn.Attributes.Add("onclick", "javascript:return confirm('你确认要推荐吗')");

        }
    }

    protected void lnkdelete_Command(object sender, CommandEventArgs e)
    {
        IKeywords rs = new RKeywords();
        int id = int.Parse(e.CommandArgument.ToString());
        int m = rs.Delete(id);
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strURl + "?page=1");
        Response.End();
    }
   
}
