﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspKnow;
using Base;

public partial class Admin_Know_KnowTypeList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        string strWhere = "1=1";
        PageNo1.Strurl = strURl;
        PageNo1.FldName = "AddDate";
        PageNo1.Table = "W_KnowType";
        PageNo1.StrGetFields = "*";
        PageNo1.PageSize = 12;
        if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
        {
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            DataTable dt = PageNo1.BindView();
            if (dt.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdKnowType.DataSource = dt.DefaultView;
            grdKnowType.DataBind();
        }
        else
        {
            int ParentID = 0;
            if (Request.QueryString["ParentID"] != null && Request.QueryString["ParentID"] != "")
            {
                ParentID = int.Parse(Request.QueryString["ParentID"]);
            }
            strWhere += " and ParentID=" + ParentID;
            PageNo1.Where = strWhere;
            PageNo1.Pageindex = 1;
            Session["strWhere"] = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdKnowType.DataSource = dt.DefaultView;
            grdKnowType.DataBind();
        }
    }
    protected void lbtnSave_Click(object sender, EventArgs e)
    {
        if (pnlKnowType.Visible)
            pnlKnowType.Visible = false;
        else
            pnlKnowType.Visible = true;
    }
    protected void btnInsert_Click(object sender, EventArgs e)
    {
        try
        {
            int parentid = 0;
            if (Request.QueryString["ParentID"] != null && Request.QueryString["ParentID"] != "")
            {
                parentid = int.Parse(Request.QueryString["ParentID"]);
            }
            KnowType type = new KnowType();
            type.Name = txtType.Text.Trim();
            type.ParentID = parentid;
            type.AddDate = DateTime.Now;
            KnowType rtype = new KnowType();
            rtype.Insert(type);
            ShowMessage("添加成功！", "Know/KnowTypeList.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("添加失败！", "Know/KnowTypeList.aspx");
        }
    }
    protected void btnReturn_Click(object sender, EventArgs e)
    {
        pnlKnowType.Visible = false;
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= grdKnowType.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdKnowType.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int id = Convert.ToInt32(grdKnowType.DataKeys[i].Value);
                KnowType ans = new KnowType();
                int m = ans.Delete(id);
            }
        }
        Bind();
    }
    protected void grdKnowType_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = int.Parse(grdKnowType.DataKeys[e.RowIndex].Value.ToString());
        KnowType ans = new KnowType();
        int m = ans.Delete(id);
        Bind();
    }
    protected void grdKnowType_RowEditing(object sender, GridViewEditEventArgs e)
    {
        grdKnowType.EditIndex = e.NewEditIndex;
        Bind();
    }
    protected void grdKnowType_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        int id = int.Parse(grdKnowType.DataKeys[e.RowIndex].Value.ToString());
        string name = ((TextBox)grdKnowType.Rows[e.RowIndex].FindControl("txtName")).Text;
        KnowType know = new KnowType();
        know.ID = id;
        know.Name = name;
        know.Update(know);
        grdKnowType.EditIndex = -1;
        Bind();
    }
    protected void grdKnowType_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        grdKnowType.EditIndex = -1;
        Bind();
    }
}
