﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using nspKnow;

public partial class Admin_Know_ProblemList : BasePage
{
    protected string Rewrite = "",WebUrl="";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Bind();
        }
        WebUrl = Base.BasePage.Config.WebURL;
        Rewrite = Base.BasePage.Config.Rewrite;
    }
    private void Bind()
    {
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        PageNo1.Table = "W_KnowProblems ";
        PageNo1.FldName = "AddDate";
        PageNo1.StrGetFields = "*";
        PageNo1.PageSize = 12;
        string strWhere = "1=1";
        if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdProblem.DataSource = dt.DefaultView;
            grdProblem.DataBind();
        }
        else
        {
            if (GetRequest.GetQueryStringValue("V") != "")
            {
                switch (GetRequest.GetQueryStringValue("v"))
                {
                    case "1":
                        strWhere += " and W_KnowProblems.State=1";
                        break;
                    case "0":
                        strWhere += " and W_KnowProblems.State=0";
                        break;
                    default:
                        break;
                }
            }
            PageNo1.Where = strWhere;
            PageNo1.Pageindex = 1;
            Session["strWhere"] = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdProblem.DataSource = dt.DefaultView;
            grdProblem.DataBind();
        }
    }
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        string strWhere = "1=1";
        if (txtCaption.Text.Trim() != "")
            strWhere += "and W_KnowProblems.Caption like '%" + Base.GetRequest.Filter(txtCaption.Text.Trim()) + "%'";
        if (txtUserName.Text.Trim() != "")
            strWhere += " and W_KnowProblems.UserName='" + Base.GetRequest.Filter(txtUserName.Text.Trim()) + "'";
        if (dropProblem.SelectedValue != "")
            strWhere += " and W_KnowProblems.State=" + dropProblem.SelectedValue;
        strWhere += " and W_KnowProblems.Verify=" + radlVerify.SelectedValue;
        Session["strWhere"] = strWhere;
        string strURl1 = Request.RawUrl;
        strURl1 = strURl1.Substring(0, strURl1.IndexOf(".aspx")) + ".aspx?page=1";
        Response.Redirect(strURl1);
        Response.End();
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= grdProblem.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdProblem.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int id = Convert.ToInt32(grdProblem.DataKeys[i].Value);
                KnowProblem pro = new KnowProblem();
                int m = pro.Delete(id);
            }
        }
        Bind();
    }
    protected void grdProblem_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = Convert.ToInt32(grdProblem.DataKeys[e.RowIndex].Value.ToString());
        KnowProblem pro = new KnowProblem();
        int m = pro.Delete(id);
        Bind();
    }
    public string GetShortDate(string strDate)
    {
        if (strDate != string.Empty)
            return Convert.ToDateTime(strDate).ToShortDateString();
        else
            return string.Empty;
    }
    /// <summary>
    /// 审核通过
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnEigible_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdProblem.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdProblem.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += "," + Convert.ToInt32(grdProblem.DataKeys[i].Value);
            }
        }
        if (strID == "")
        {
            Base.BasePage.ShowMessage("您还没有选择信息！", "Trade/SupplyManage.aspx");
            return;
        }

        if (Solely.Other.UpOnlyDate("W_KnowProblems", "Verify=1", "id in(" + strID.Substring(1) + ")"))
        {
            Bind();

        }
        else
        {
            Base.BasePage.ShowMessage("审核出现错误！", "Trade/SupplyManage.aspx");
        }
    }
    /// <summary>
    /// 审核未通过
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnDisqualification_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdProblem.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdProblem.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += "," + Convert.ToInt32(grdProblem.DataKeys[i].Value);
            }
        }
        if (strID == "")
        {
            Base.BasePage.ShowMessage("您还没有选择信息！", "Trade/SupplyManage.aspx");
            return;
        }

        if (Solely.Other.UpOnlyDate("W_KnowProblems", "Verify=0", "id in(" + strID.Substring(1) + ")"))
        {

            Bind();
        }
        else
        {
            Base.BasePage.ShowMessage("审核出现错误！", "Trade/SupplyManage.aspx");
        }
    }
}
