﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using nspLable.Manage;
using System.Text;
using Agent;

public partial class admin_Lable_Model_AgentList_Pic : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {

                SystemLableTypeBind();
                AgentTypeBind();
                Bind();
            }
            else
            {
                SystemLableTypeBind();
                AgentTypeBind();
            }

        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });

            int i = 0;
            while (i < str.Length)
            {
                radlIndType.SelectedValue = str[0];
                dropTypeID.SelectedValue = str[1];
                txtNum.Text = str[2];
                txtRowsNum.Text = str[3];
                radlAgeAttribute.SelectedValue = str[4];
                radlWitchType.SelectedValue = str[5];
                txtPicWidth.Text = str[6];
                txtPicHeight.Text = str[7];
                txtPicClass.Text = str[8];
               // txtTitleClass.Text = str[9];
                txtTitleSize.Text = str[10];
                dropOrderBy.SelectedValue = str[11];
                dropTarget.SelectedValue = str[12];
                break;
            }

            if (radlWitchType.SelectedValue == "1")
            {
               // trTitleClass.Style.Add("display", "block");
                trTitleSize.Style.Add("display", "block");
            }
            else
            {
               // trTitleClass.Style.Add("display", "none");
                trTitleSize.Style.Add("display", "none");
            }
        }
    }
    /// <summary>
    /// 创业加盟类别 
    /// </summary>
    private void AgentTypeBind()
    {
        IAgentType RAgent = new RAgentType();
        DataTable dt = RAgent.GetDataTable();
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataTextField = "Name";
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataBind();
        ListItem li = new ListItem("全部", "0");
        dropTypeID.Items.Add(li);
        li.Selected = true;
    }
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
     
        if (Request.QueryString["ID"] != null)
        {
            try
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystemLable TSystem = new TSystemLable();
                TSystem.ID = id;
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_AgentList_Pic";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(radlIndType.SelectedValue + "|");     //信息类型
                stringStr.Append(dropTypeID.SelectedValue + "|");      //信息分类
                stringStr.Append(txtNum.Text + "|");               //信息列表数目
                stringStr.Append(txtRowsNum.Text + "|");               //每行显示条数
                stringStr.Append(radlAgeAttribute.SelectedValue + "|");//信息属性 
                stringStr.Append(radlWitchType.SelectedValue + "|");   //显示方式
                stringStr.Append(txtPicWidth.Text + "|");              //图片宽度
                stringStr.Append(txtPicHeight.Text + "|");             //图片高度
                stringStr.Append(txtPicClass.Text + "|");              //图片样式
                stringStr.Append("" + "|");            //标题样式
                stringStr.Append(txtTitleSize.Text + "|");             //标题字数
                stringStr.Append(dropOrderBy.SelectedValue + "|");     //排序方式
                stringStr.Append(dropTarget.SelectedValue);            //链接目标

                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Update(TSystem);
                Messagess.ShowMessage("标签修改成功！");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
        else
        {
            try
            {
                TSystemLable TSystem = new TSystemLable();
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_AgentList_Pic";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(radlIndType.SelectedValue + "|");     //信息类型
                stringStr.Append(dropTypeID.SelectedValue + "|");      //信息分类
                stringStr.Append(txtNum.Text + "|");               //信息列表数目
                stringStr.Append(txtRowsNum.Text + "|");               //每行显示条数
                stringStr.Append(radlAgeAttribute.SelectedValue + "|");//信息属性 
                stringStr.Append(radlWitchType.SelectedValue + "|");   //显示方式
                stringStr.Append(txtPicWidth.Text + "|");              //图片宽度
                stringStr.Append(txtPicHeight.Text + "|");             //图片高度
                stringStr.Append(txtPicClass.Text + "|");              //图片样式
                //stringStr.Append(txtTitleClass.Text + "|");            //标题样式
                stringStr.Append("" + "|");                             //标题样式
                stringStr.Append(txtTitleSize.Text + "|");             //标题字数
                stringStr.Append(dropOrderBy.SelectedValue + "|");     //排序方式
                stringStr.Append(dropTarget.SelectedValue);            //链接目标

                TSystem.Info = stringStr.ToString();

                ISystemLable RSystem = new RSystemLable();
                RSystem.Insert(TSystem);
                Messagess.ShowMessage("标签添加成功！");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
    }
    protected void radlWitchType_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (radlWitchType.SelectedValue == "1")
        {
           // trTitleClass.Style.Add("display", "block");
            trTitleSize.Style.Add("display", "block");
        }
        else
        {
           // trTitleClass.Style.Add("display", "none");
            trTitleSize.Style.Add("display", "none");
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
    }
}