﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using nspLable.Manage;
using System.Text;
using Agent;

public partial class admin_Lable_Model_AgentList_Str : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {

                SystemLableTypeBind();
                AgentTypeBind();
                Bind();
            }
            else
            {
                SystemLableTypeBind();
                AgentTypeBind();
            }

        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });

            int i = 0;
            while (i < str.Length)
            {
                radlIndType.SelectedValue = str[0];
                dropTypeID.SelectedValue = str[1];
                txtNum.Text = str[2];
                txtRowsNum.Text = str[3];
                txtTitleSize.Text = str[4];
                txtTitleClass.Text = str[5];
                dropTarget.SelectedValue = str[6];
                radlShowType.SelectedValue = str[7];
                radRecommend.SelectedValue = str[8];
                txtTypeClass.Text = str[9];
                radlShowDate.SelectedValue = str[10];

                dropDateFormat.SelectedValue = str[11];
                dropOrderBy.SelectedValue = str[12];
                break;
            }
              
        }
    }
    /// <summary>
    /// 创业加盟类别 
    /// </summary>
    private void AgentTypeBind()
    {
        IAgentType RAgent = new RAgentType();
        DataTable dt = RAgent.GetDataTable();
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataTextField = "Name";
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataBind();
        ListItem li = new ListItem("全部", "0");
        dropTypeID.Items.Add(li);

        li.Selected = true;
    }
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {

        if (Request.QueryString["ID"] != null)
        {
            try
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystemLable TSystem = new TSystemLable();
                TSystem.ID = id;
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_AgentList_Str";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(radlIndType.SelectedValue + "|");     //信息类型
                stringStr.Append(dropTypeID.SelectedValue + "|");      //信息分类
                stringStr.Append(txtNum.Text + "|");                   //信息列表数目
                stringStr.Append(txtRowsNum.Text + "|");               //每行显示条数
                stringStr.Append(txtTitleSize.Text + "|");             //标题字数
                stringStr.Append(txtTitleClass.Text + "|");            //标题样式
                stringStr.Append(dropTarget.SelectedValue + "|");      //链接目标
                stringStr.Append(radlShowType.SelectedValue + "|");    //是否显示类别
                stringStr.Append(radRecommend.SelectedValue + "|");
                stringStr.Append(txtTypeClass.Text + "|");             //类别样式 
                stringStr.Append(radlShowDate.SelectedValue + "|");    //是否显示日期
                stringStr.Append(dropDateFormat.SelectedValue + "|");  //日期格式
                stringStr.Append(dropOrderBy.SelectedValue);           //排序方式

                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Update(TSystem);
                Messagess.ShowMessage("标签修改成功！");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
        else
        {
            try
            {
                TSystemLable TSystem = new TSystemLable();
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_AgentList_Str";
                
                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(radlIndType.SelectedValue + "|");     //信息类型
                stringStr.Append(dropTypeID.SelectedValue + "|");      //信息分类
                stringStr.Append(txtNum.Text + "|");                   //信息列表数目
                stringStr.Append(txtRowsNum.Text + "|");               //每行显示条数
                stringStr.Append(txtTitleSize.Text + "|");             //标题字数
                stringStr.Append(txtTitleClass.Text + "|");            //标题样式
                stringStr.Append(dropTarget.SelectedValue + "|");      //链接目标
                stringStr.Append(radlShowType.SelectedValue + "|");    //是否显示类别
                stringStr.Append(radRecommend.SelectedValue + "|");
                stringStr.Append(txtTypeClass.Text + "|");             //类别样式 
                stringStr.Append(radlShowDate.SelectedValue + "|");    //是否显示日期
                stringStr.Append(dropDateFormat.SelectedValue + "|");  //日期格式
                stringStr.Append(dropOrderBy.SelectedValue);           //排序方式

                TSystem.Info = stringStr.ToString();

                ISystemLable RSystem = new RSystemLable();
                RSystem.Insert(TSystem);
                Messagess.ShowMessage("标签添加成功！");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
    }
}
