﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Product;
using Area;
using System.Text;
using nspLable.Manage;

public partial class admin_Lable_Model_CompanyList_Pic : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {
                IndustryTypeBind();
                SystemLableTypeBind();
                AreaBind();
                Bind();
            }
            else
            {
                IndustryTypeBind();
                SystemLableTypeBind();
                AreaBind();
            }
        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });

            int i = 0;
            while (i < str.Length)
            {
                txtNum.Text = str[0];
                txtRowsNum.Text = str[1];
                radlProAttribute.SelectedValue = str[2];
                dropWhitchType.SelectedValue = str[3];
                dropTarget.SelectedValue = str[4];
                dropIndType.SelectedValue = str[5];
                dropArea.SelectedValue = str[6];
                dropOrderBy.SelectedValue = str[7];
                txtPicHeight.Text = str[8];
                txtPicWidth.Text = str[9];
                txtPicClas.Text = str[10];
                txtTitleSize.Text = str[11];
                txtTitleClass.Text = str[12];
                txtSummarySize.Text = str[13];
                txtSummaryClass.Text = str[14];
                break;
            }
            if (dropWhitchType.SelectedValue == "1")
            {
                trTitleSize.Style.Add("display", "block");
                trTitleClass.Style.Add("display", "block");
            }
            else if (dropWhitchType.SelectedValue == "2")
            {
                trSummarySize.Style.Add("display", "block");
                trSummaryClass.Style.Add("display", "block");
            }
            else
            {
                trTitleSize.Style.Add("display", "none");
                trTitleClass.Style.Add("display", "none");
                trSummarySize.Style.Add("display", "none");
                trSummaryClass.Style.Add("display", "none");
            }
        }
    }
    /// <summary>
    /// 行业类别
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void IndustryTypeBind()
    {
        IIndustryType IInd = new RIndustryType();
        DataTable dt = IInd.GetDataTable(0);
        dropIndType.DataSource = dt.DefaultView;
        dropIndType.DataValueField = "ID";
        dropIndType.DataTextField = "Type";
        dropIndType.DataBind();
        ListItem li = new ListItem("全部", "0");
        dropIndType.Items.Add(li);
        li.Selected = true;
    }
    /// <summary>
    /// 绑定系统标签类别
    /// </summary>
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }
    /// <summary>
    /// 绑定地区一级分类
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void AreaBind()
    {
        IArea RArea = new RArea();
        DataTable dt = RArea.GetDataTable(0);
        dropArea.DataSource = dt.DefaultView;
        dropArea.DataTextField = "Name";
        dropArea.DataValueField = "ID";
        dropArea.DataBind();
        ListItem li = new ListItem("全部", "0");
        dropArea.Items.Add(li);
        li.Selected = true;
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (dropArea.SelectedValue == "")
        {
            ShowMessage("请选择地区！");
            return;
        }
        if (Request.QueryString["ID"] != null)
        {
            try
            {

               
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystemLable TSystem = new TSystemLable();
                TSystem.ID = id;
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_CompanyList_Pic";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(txtNum.Text + "|");                    //信息列表数目
                stringStr.Append(txtRowsNum.Text + "|");                //每行显示几条
                stringStr.Append(radlProAttribute.SelectedValue + "|"); //信息列表属性
                stringStr.Append(dropWhitchType.SelectedValue + "|");   //列表显示样式
                stringStr.Append(dropTarget.SelectedValue + "|");       //文章打开方式
                stringStr.Append(dropIndType.SelectedValue + "|");      //行业类别
                stringStr.Append(dropArea.SelectedValue + "|");         //所属地区分类
                stringStr.Append(dropOrderBy.SelectedValue + "|");      //排序方式
                stringStr.Append(txtPicHeight.Text + "|");              //Logo高度
                stringStr.Append(txtPicWidth.Text + "|");               //Logo宽度
                stringStr.Append(txtPicClas.Text + "|");                //图片样式
                stringStr.Append(txtTitleSize.Text + "|");              //标题最多字符数
                stringStr.Append(txtTitleClass.Text + "|");             //标题样式
                stringStr.Append(txtSummarySize.Text + "|");            //简介大小
                stringStr.Append(txtSummaryClass.Text);                 //简介样式
               
                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Update(TSystem);
                ShowMessage("标签修改成功！");

                Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");

            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
        else
        {
            try
            {
              
                TSystemLable TSystem = new TSystemLable();

                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_CompanyList_Pic";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(txtNum.Text + "|");                    //信息列表数目
                stringStr.Append(txtRowsNum.Text + "|");                //每行显示几条
                stringStr.Append(radlProAttribute.SelectedValue + "|"); //信息列表属性
                stringStr.Append(dropWhitchType.SelectedValue + "|");   //列表显示样式
                stringStr.Append(dropTarget.SelectedValue + "|");       //文章打开方式
                stringStr.Append(dropIndType.SelectedValue + "|");      //行业类别
                stringStr.Append(dropArea.SelectedValue + "|");         //所属地区分类
                stringStr.Append(dropOrderBy.SelectedValue + "|");      //排序方式
                stringStr.Append(txtPicHeight.Text + "|");              //Logo高度
                stringStr.Append(txtPicWidth.Text + "|");                    //Logo宽度
                stringStr.Append(txtPicClas.Text + "|");                //图片样式
                stringStr.Append(txtTitleSize.Text + "|");              //标题最多字符数
                stringStr.Append(txtTitleClass.Text + "|");             //标题样式
                stringStr.Append(txtSummarySize.Text + "|");            //简介大小
                stringStr.Append(txtSummaryClass.Text);                 //简介样式

                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Insert(TSystem);
                ShowMessage("标签添加成功！");

                Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");

            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");

    }


    protected void dropWhitchType_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (dropWhitchType.SelectedValue == "1")
        {
            trTitleSize.Style.Add("display", "block");
            trTitleClass.Style.Add("display", "block");
        }
        else if (dropWhitchType.SelectedValue == "2")
        {
            trTitleSize.Style.Add("display", "block");
            trTitleClass.Style.Add("display", "block");
            trSummarySize.Style.Add("display", "block");
            trSummaryClass.Style.Add("display", "block");
        }
        else
        {
            trTitleSize.Style.Add("display", "none");
            trTitleClass.Style.Add("display", "none");
            trSummarySize.Style.Add("display", "none");
            trSummaryClass.Style.Add("display", "none");
        }
    }
}
