﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using nspLable.Manage;
using System.Text;
using Product;

public partial class admin_Lable_Model_CompanyList_Str : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {

                SystemLableTypeBind();
                IndustryTypeBind();
                ProvinceBind();
                Bind();
                GradeBind();
            }
            else
            {
                SystemLableTypeBind();
                IndustryTypeBind();
                ProvinceBind();
                GradeBind();
            }

        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });

            int i = 0;
            while (i < str.Length)
            {
                dropIndType.SelectedValue = str[0];
                dropArea.SelectedValue = str[1];
                drpGrade.SelectedValue = str[2];
                txtNum.Text = str[3];
                txtRowsNum.Text = str[4];
                txtTitleClass.Text = str[7];
                txtTitleSize.Text = str[6];
                dropOrderBy.SelectedValue = str[5];
                dropTarget.SelectedValue = str[8];
                break;
                
            }


        }
    }

    /// <summary>
    /// 行业类别
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void IndustryTypeBind()
    {
        IIndustryType IInd = new RIndustryType();
        DataTable dt = IInd.GetDataTable(0);
        dropIndType.DataSource = dt.DefaultView;
        dropIndType.DataValueField = "ID";
        dropIndType.DataTextField = "Type";
        dropIndType.DataBind();
        ListItem li = new ListItem("全部", "0");
        dropIndType.Items.Add(li);
        li.Selected = true;
    }


    /// <summary>
    /// 行业类别
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void GradeBind()
    {
        VipGrade.TVipGrade vp = new VipGrade.TVipGrade();
        VipGrade.IVipGrade ivp = new VipGrade.RVipGrade();
        
        DataSet dt =ivp.GetDataTable();
        drpGrade.DataSource = dt.Tables[0].DefaultView;
        //drpGrade.DataValueField = "ID";
        //drpGrade.DataTextField = "Name";
        this.drpGrade.DataTextField = dt.Tables[0].Columns["Name"].ToString();
        this.drpGrade.DataValueField = dt.Tables[0].Columns["ID"].ToString();
        drpGrade.DataBind();
        //ListItem li = new ListItem("全部", "0");
        //dropIndType.Items.Add(li);
        //li.Selected = true;
    }

    /// <summary>
    /// 绑定省市
    /// </summary>
    private void ProvinceBind()
    {
        DataSet ds = new DataSet();
        ds.ReadXml(@Server.MapPath("~/xml/Province.xml"));
        dropArea.DataSource = ds.Tables[0];
        dropArea.DataTextField = ds.Tables[0].Columns[1].ToString();
        dropArea.DataValueField = ds.Tables[0].Columns[0].ToString();
        dropArea.DataBind();
    }
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {

        if (Request.QueryString["ID"] != null)
        {
            try
            {
                string myValue = "";
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystemLable TSystem = new TSystemLable();
                TSystem.ID = id;
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_CompanyList_Str";
                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropIndType.SelectedValue + "|");           //行业类别
                stringStr.Append(dropArea.SelectedValue + "|");              //所属地区分类
                stringStr.Append(drpGrade.SelectedValue + "|");
                stringStr.Append(txtNum.Text + "|");                         //信息列表数目
                stringStr.Append(txtRowsNum.Text + "|");                     //每行的列数
                stringStr.Append(dropOrderBy.SelectedValue + "|");           //排序方式
                stringStr.Append(txtTitleSize.Text + "|");                   //标题最多字符数
                stringStr.Append(txtTitleClass.Text + "|");                  //CSS类名
                stringStr.Append(dropTarget.SelectedValue);                  //文章打开方式
                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Update(TSystem);
                Messagess.ShowMessage("标签修改成功！");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
        else
        {
            try
            {
                string myValue = "";
                TSystemLable TSystem = new TSystemLable();
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_CompanyList_Str";
                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropIndType.SelectedValue + "|");           //行业类别
                stringStr.Append(dropArea.SelectedValue + "|");              //所属地区分类
                stringStr.Append(drpGrade.SelectedValue + "|");
                stringStr.Append(txtNum.Text + "|");                         //信息列表数目
                stringStr.Append(txtRowsNum.Text + "|");                     //每行的列数
                //stringStr.Append(radlAttribute.SelectedValue + "|");         //信息列表属性
                stringStr.Append(dropOrderBy.SelectedValue + "|");           //排序方式
                stringStr.Append(txtTitleSize.Text + "|");                   //标题字数
                stringStr.Append(txtTitleClass.Text + "|");                  //CSS类名
                //foreach (ListItem li in chklShowInfo.Items)
                //{
                //    if (li.Selected)
                //    {
                //        myValue += "1,";
                //    }
                //    else
                //    {
                //        myValue += "0,";
                //    }
                //}
                //if (myValue != "")
                //{
                //    myValue = myValue.Substring(0, myValue.Length - 1);
                //}
                //stringStr.Append(myValue + "|");       //显示内容
                stringStr.Append(dropTarget.SelectedValue);            //文章打开方式


                TSystem.Info = stringStr.ToString();

                ISystemLable RSystem = new RSystemLable();
                RSystem.Insert(TSystem);
                Messagess.ShowMessage("标签添加成功！");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
    }

    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
    }
}
