﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using nspLable.Manage;
using System.Text;

public partial class admin_Lable_Model_DetailNewProduct : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {
                SystemLableTypeBind();
                Bind();
            }
            else
            {
                SystemLableTypeBind();
            }
        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });

            int i = 0;
            while (i < str.Length)
            {
                txtNum.Text = str[0];
                txtRowsNum.Text = str[1];
                dropWhichType.SelectedValue = str[2];
                txtPicWidth.Text = str[3];
                txtPicHeight.Text = str[4];
                txtPicClass.Text = str[5];
                txtTitleSize.Text = str[6];
                txtTitleClass.Text = str[7];
                dropTarget.SelectedValue = str[8];
                radlStrAttribute.SelectedValue = str[9];
                radlRecommend.SelectedValue = str[10];
                break;
            }
        }
    }

    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null)
        {
            try
            {
             
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystemLable TSystem = new TSystemLable();
                TSystem.ID = id;
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_DetailNewProduct";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(txtNum.Text + "|");                   //显示条数 
                stringStr.Append(txtRowsNum.Text + "|");               //每行的条数
                stringStr.Append(dropWhichType.SelectedValue + "|");   //信息类型
                stringStr.Append(txtPicWidth.Text + "|");              //图片宽度
                stringStr.Append(txtPicHeight.Text + "|");             //图片高度
                stringStr.Append(txtPicClass.Text + "|");              //图片样式
                stringStr.Append(txtTitleSize.Text + "|");             //标题字数
                stringStr.Append(txtTitleClass.Text + "|");            //标题样式
                stringStr.Append(dropTarget.SelectedValue + "|");      //打开方式
                stringStr.Append(radlStrAttribute.SelectedValue + "|");//属性
                stringStr.Append(radlRecommend.SelectedValue );   //是否推荐
                
                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Update(TSystem);
                Messagess.ShowMessage("标签修改成功！");

                Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");

            }
            catch (Exception ex)
            {

                Messagess.ShowMessage(ex.Message);
            }

        }
        else
        {
            try
            {
                TSystemLable TSystem = new TSystemLable();
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_DetailNewProduct";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(txtNum.Text + "|");                   //显示条数 
                stringStr.Append(txtRowsNum.Text + "|");               //每行的条数
                stringStr.Append(dropWhichType.SelectedValue + "|");   //信息类型
                stringStr.Append(txtPicWidth.Text + "|");              //图片宽度
                stringStr.Append(txtPicHeight.Text + "|");             //图片高度
                stringStr.Append(txtPicClass.Text + "|");              //图片样式
                stringStr.Append(txtTitleSize.Text + "|");             //标题字数
                stringStr.Append(txtTitleClass.Text + "|");            //标题样式
                stringStr.Append(dropTarget.SelectedValue + "|");      //打开方式
                stringStr.Append(radlStrAttribute.SelectedValue + "|");//属性
                stringStr.Append(radlRecommend.SelectedValue + "|");   //是否推荐

                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Insert(TSystem);
                Messagess.ShowMessage("标签添加成功！");

                Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");

            }
            catch (Exception ex)
            {

                Messagess.ShowMessage(ex.Message);
            }
        }
    }


    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");
    }
}
