﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspLable.Manage;
using System.Text;
using Base;

public partial class Admin_Lable_Model_NewsList_Top : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {
                SystemLableTypeBind();
                Bind();
            }
            else
            {
                SystemLableTypeBind();
            }
        }
    }

    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });
            txtNum.Text = str[0];
            txtTitleLenght.Text = str[1];
            txtTitleClass.Text = str[2];
            dropTarget.SelectedValue = str[3];
        }
    }


    /// <summary>
    /// 绑定系统标签类别
    /// </summary>
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            TSystemLable TSystem = new TSystemLable();
            TSystem.Name = "SY_" + txtEngLishName.Text;              //标签名称
            TSystem.Remarks = txtChineseName.Text;                   //中文名称
            TSystem.TypeID = int.Parse(dropLableType.SelectedValue); //所属栏目 
            TSystem.Title = "SY_DiggList";
            StringBuilder stringStr = new StringBuilder();
            stringStr.Append(txtNum.Text + "|");                     //显示条数
            stringStr.Append(txtTitleLenght.Text + "|");             //标题字数
            stringStr.Append(txtTitleClass.Text + "|");              //标题样式
            stringStr.Append(dropTarget.SelectedValue );             //链接目标
            TSystem.Info = stringStr.ToString();
            ISystemLable RSystem = new RSystemLable();

            if (Request.QueryString["ID"] != null)
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystem.ID = id;
                RSystem.Update(TSystem);
                ShowMessage("标签修改成功！");
            }
            else
            {
                RSystem.Insert(TSystem);
                ShowMessage("标签添加成功！");
            }
            Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");

        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }



    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");
    }
}
