﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspLable.Manage;
using System.Text;
using Base;
using Expo;
using Consultative;

public partial class admin_Lable_Model_ExpoNews_Pic : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {
                SystemLableTypeBind();
                ConsultativeTypeBind();
                Bind();
            }
            else
            {
                SystemLableTypeBind();
                ConsultativeTypeBind();
            }

        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });

            int i = 0;
            while (i < str.Length)
            {
                dropWitchType.SelectedValue = str[0];
                txtNum.Text = str[1];
                txtRowsNum.Text = str[2];
                dropTypeID.SelectedValue = str[3];
                txtPicWidth.Text = str[4];
                txtPicHeigth.Text = str[5];
                txtPicFrame.Text = str[6];
                radlDisplayTitle.SelectedValue = str[7];
                txtTitleClass.Text = str[8];
                txtTitleSize.Text = str[9];
                dropTarget.SelectedValue = str[10];
                txtDetailSize.Text = str[11];
                radlNewsAttribute.SelectedValue = str[12];
                dropOrderBy.SelectedValue = str[13];
                break;
            }
           
            if (dropWitchType.SelectedValue == "1")
            {
                trDetailSize.Style.Add("display", "block");
            }
            else
            {
                trDetailSize.Style.Add("display", "none");
            }
            
        }
    }
    /// <summary>
    /// 资讯类别 
    /// </summary>
    private void ConsultativeTypeBind()
    {
        RExpoNewsType RExpoNews = new RExpoNewsType();
        DataTable dt = RExpoNews.GetDataTable();
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataTextField = "type";
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataBind();
        ListItem li = new ListItem("全部", "0");
        dropTypeID.Items.Add(li);
        li.Selected = true;
    }
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null)
        {
            try
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystemLable TSystem = new TSystemLable();
                TSystem.ID = id;
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_ExpoNews_Pic";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropWitchType.SelectedValue + "|");     //哪种形式显示图片
                stringStr.Append(txtNum.Text + "|");                     //信息列表数目
                stringStr.Append(txtRowsNum.Text + "|");                 //每行显示条数
                stringStr.Append(dropTypeID.SelectedValue + "|");        //展会类别
                stringStr.Append(txtPicWidth.Text + "|");                //图片宽度
                stringStr.Append(txtPicHeigth.Text + "|");               //图片高度
                stringStr.Append(txtPicFrame.Text + "|");                //图片边框
                stringStr.Append(radlDisplayTitle.SelectedValue + "|");  //是否显示标题
                stringStr.Append(txtTitleClass.Text + "|");              //标题样式
                stringStr.Append(txtTitleSize.Text + "|");               //显示标题字数
                stringStr.Append(dropTarget.SelectedValue + "|");        //链接目标
                stringStr.Append(txtDetailSize.Text + "|");              //内容显示字数
                stringStr.Append(radlNewsAttribute.SelectedValue + "|"); //文章属性
                stringStr.Append(dropOrderBy.SelectedValue);             //排序方式

                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Update(TSystem);
                //ShowMessage("标签修改成功！", "Lable/SystemLable/SystemLableManage.aspx");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {
                //ShowMessage("标签修改失败!", "Lable/SystemLable/SystemLableManage.aspx");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
        }
        else
        {
            try
            {
                TSystemLable TSystem = new TSystemLable();
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_ExpoNews_Pic";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropWitchType.SelectedValue + "|");     //哪种形式显示图片
                stringStr.Append(txtNum.Text + "|");                     //信息列表数目
                stringStr.Append(txtRowsNum.Text + "|");                 //每行显示条数
                stringStr.Append(dropTypeID.SelectedValue + "|");        //展会类别
                stringStr.Append(txtPicWidth.Text + "|");                //图片宽度
                stringStr.Append(txtPicHeigth.Text + "|");               //图片高度
                stringStr.Append(txtPicFrame.Text + "|");                //图片边框
                stringStr.Append(radlDisplayTitle.SelectedValue + "|");  //是否显示标题
                stringStr.Append(txtTitleClass.Text + "|");              //标题样式
                stringStr.Append(txtTitleSize.Text + "|");               //显示标题字数
                stringStr.Append(dropTarget.SelectedValue + "|");        //链接目标
                stringStr.Append(txtDetailSize.Text + "|");              //内容显示字数
                stringStr.Append(radlNewsAttribute.SelectedValue + "|"); //文章属性
                stringStr.Append(dropOrderBy.SelectedValue);             //排序方式

                TSystem.Info = stringStr.ToString();

                ISystemLable RSystem = new RSystemLable();
                RSystem.Insert(TSystem);
                //ShowMessage("标签添加成功！", "Lable/SystemLable/SystemLableManage.aspx");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {
                //ShowMessage("标签添加失败!", "Lable/SystemLable/SystemLableManage.aspx");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
    }
    protected void dropWitchType_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (dropWitchType.SelectedValue == "1")
        {
            trDetailSize.Style.Add("display", "block");
        }
        else
        {
            trDetailSize.Style.Add("display", "none");
        }
    }
}
