﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using System.Text;
using Expo;
using nspLable.Manage;
using Consultative;

public partial class admin_Lable_Model_ExpoNews_Str : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {

                SystemLableTypeBind();
                ConsultativeTypeBind();
                Bind();
            }
            else
            {
                SystemLableTypeBind();
                ConsultativeTypeBind();
            }

        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });

            int i = 0;
            while (i < str.Length)
            {
                dropTypeID.SelectedValue = str[0];
                txtNum.Text = str[1];
                txtRowsNum.Text = str[2];
                radlDisplayType.SelectedValue = str[3];
                txtTitleSize.Text = str[4];
                txtTitleClass.Text =str[5];
                dropTarget.SelectedValue = str[6];
                radlDisplayType.SelectedValue = str[7];
                dropDateFormat.SelectedValue = str[8];
                radlNewsAttribute.SelectedValue = str[9];
                radlDisplayDetail.SelectedValue = str[10];
                txtDetailSize.Text = str[11];
                dropOrderBy.SelectedValue = str[12];
                break;
            }
            if (radlNewsAttribute.SelectedValue == "3")
            {
                trDisplayDetail.Style.Add("display", "block");
            }
            else
            {
                trDisplayDetail.Style.Add("display", "none");
            }
            if (radlDisplayDetail.SelectedValue == "0")
            {
                trDetailSize.Style.Add("display", "block");
            }
            else
            {
                trDetailSize.Style.Add("display", "none");
            }
        }
    }
    /// <summary>
    /// 资讯类别 
    /// </summary>
    private void ConsultativeTypeBind()
    {
        RExpoNewsType RExpoNews = new RExpoNewsType();
        DataTable dt = RExpoNews.GetDataTable();
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataTextField = "type";
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataBind();
        ListItem li = new ListItem("全部","0");
        dropTypeID.Items.Add(li);
        li.Selected = true;
    }
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
     
        if (Request.QueryString["ID"] != null)
        {
            try
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystemLable TSystem = new TSystemLable();
                TSystem.ID = id;
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_ExpoNews_Str";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropTypeID.SelectedValue + "|");     //资讯类别
                stringStr.Append(txtNum.Text + "|");                  //信息列表数目
                stringStr.Append(txtRowsNum.Text + "|");              //每行显示条数
                stringStr.Append(radlDisplayType.SelectedValue + "|");//是否显示资讯类别
                stringStr.Append(txtTitleSize.Text + "|");            //显示标题字数
                stringStr.Append(txtTitleClass.Text + "|");           //标题样式
                stringStr.Append(dropTarget.SelectedValue + "|");     //链接目标
                stringStr.Append(radlDisplayType.SelectedValue + "|");//是否显示日期
                stringStr.Append(dropDateFormat.SelectedValue + "|"); //日期格式
                stringStr.Append(radlNewsAttribute.SelectedValue + "|");//文章属性
                stringStr.Append(radlDisplayDetail.SelectedValue + "|");//文章内容
                stringStr.Append(txtDetailSize.Text + "|");            //文章字数
                stringStr.Append(dropOrderBy.SelectedValue);           //排序方式

                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Update(TSystem);
                Messagess.ShowMessage("标签修改成功！");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
        else
        {
            try
            {
                TSystemLable TSystem = new TSystemLable();
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_ExpoNews_Str";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropTypeID.SelectedValue + "|");     //资讯类别
                stringStr.Append(txtNum.Text + "|");                  //信息列表数目
                stringStr.Append(txtRowsNum.Text + "|");              //每行显示条数
                stringStr.Append(radlDisplayType.SelectedValue + "|");//是否显示资讯类别
                stringStr.Append(txtTitleSize.Text + "|");            //显示标题字数
                stringStr.Append(txtTitleClass.Text + "|");           //标题样式
                stringStr.Append(dropTarget.SelectedValue + "|");     //链接目标
                stringStr.Append(radlDisplayType.SelectedValue + "|");//是否显示日期
                stringStr.Append(dropDateFormat.SelectedValue + "|"); //日期格式
                stringStr.Append(radlNewsAttribute.SelectedValue + "|");//文章属性
                stringStr.Append(radlDisplayDetail.SelectedValue + "|");//文章内容
                stringStr.Append(txtDetailSize.Text + "|");            //文章字数
                stringStr.Append(dropOrderBy.SelectedValue);           //排序方式

                TSystem.Info = stringStr.ToString();

                ISystemLable RSystem = new RSystemLable();
                RSystem.Insert(TSystem);
                Messagess.ShowMessage("标签添加成功！");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
    }
    protected void radlNewsAttribute_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (radlNewsAttribute.SelectedValue == "3")
        {
            trDisplayDetail.Style.Add("display", "block");
        }
        else
        {
            trDisplayDetail.Style.Add("display", "none");
        }
    }
    protected void radlDisplayDetail_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (radlDisplayDetail.SelectedValue == "0")
        {
            trDetailSize.Style.Add("display", "block");
        }
        else
        {
            trDetailSize.Style.Add("display", "none");
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
    }
}
