﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using System.Text;
using Expo;
using nspLable.Manage;

public partial class admin_Lable_Model_Expo_Pic : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {

                SystemLableTypeBind();
                ExpoTypeBind();
                Bind();
            }
            else
            {
                SystemLableTypeBind();
                ExpoTypeBind();
            }

        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });

            int i = 0;
            while (i < str.Length)
            {
                dropWitchType.SelectedValue = str[0];
                txtNum.Text = str[1];
                txtRowsNum.Text = str[2];
                dropTypeID.SelectedValue = str[3];
                radlCategory.SelectedValue = str[4];
                txtPicWidth.Text = str[5];
                txtPicHeigth.Text = str[6];
                txtPicFrame.Text = str[7];
                dropisTitle.SelectedValue = str[8];
                txtTitleClass.Text = str[9];
                txtTitleSize.Text = str[10];
                dropTarget.SelectedValue = str[11];
                if (str[12] != "")
                {
                    string[] lisNew = str[12].Split(new char[] { ',' });
                    for (int j = 0; j < lisNew.Length; j++)
                    {
                        if (lisNew[j].ToString() == "1")
                            chklExpoAttribute.Items[j].Selected = true;
                    }
                    if (str[0] == "1")
                    {
                        trExpoAttribute.Style.Add("display", "block");
                    }
                    else
                    {
                        trExpoAttribute.Style.Add("display", "none");
                    }
                }
                break;
            }
        }
    }
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }
    /// <summary>
    /// 展会类别
    /// </summary>
    private void ExpoTypeBind()
    {
        IExpoType REx = new RExpoType();
        DataTable dt = REx.GetDataTable();
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataTextField = "Type";
        dropTypeID.DataBind();
        ListItem li = new ListItem("全部", "0");
        dropTypeID.Items.Add(li);
        li.Selected = true;
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null)
        {
            try
            {
                string myValue = "";
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystemLable TSystem = new TSystemLable();
                TSystem.ID = id;
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_Expo_Pic";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropWitchType.SelectedValue + "|");  //显示图片
                stringStr.Append(txtNum.Text + "|");                  //显示信息条数
                stringStr.Append(txtRowsNum.Text + "|");              //每行显示条数
                stringStr.Append(dropTypeID.SelectedValue + "|");     //展会类别
                stringStr.Append(radlCategory.SelectedValue + "|");   //展会分类
                stringStr.Append(txtPicWidth.Text + "|");             //图片宽度
                stringStr.Append(txtPicHeigth.Text + "|");            //图片高度
                stringStr.Append(txtPicFrame.Text + "|");             //图片边框
                stringStr.Append(dropisTitle.SelectedValue + "|");    //是否显示标题
                stringStr.Append(txtTitleClass.Text + "|");           //标题样式
                stringStr.Append(txtTitleSize.Text + "|");            //显示标题字数
                stringStr.Append(dropTarget.SelectedValue + "|");     //链接目标

                foreach (ListItem li in chklExpoAttribute.Items)
                {
                    if (li.Selected)
                    {
                        myValue += "1,";
                    }
                    else
                    {
                        myValue += "0,";
                    }
                }
                if (myValue != "")
                {
                    myValue = myValue.Substring(0, myValue.Length - 1);
                }
                stringStr.Append(myValue);                              //属性显示

                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Update(TSystem);
                ShowMessage("标签修改成功!");
            }
            catch (Exception ex)
            {
                ShowMessage("标签修改失败!");
            }
        }
        else
        {
            try
            {
                string myValue = "";
                TSystemLable TSystem = new TSystemLable();
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_Expo_Pic";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropWitchType.SelectedValue + "|");  //显示图片
                stringStr.Append(txtNum.Text + "|");                  //显示信息条数
                stringStr.Append(txtRowsNum.Text + "|");              //每行显示条数
                stringStr.Append(dropTypeID.SelectedValue + "|");     //展会类别
                stringStr.Append(radlCategory.SelectedValue + "|");   //展会分类
                stringStr.Append(txtPicWidth.Text + "|");             //图片宽度
                stringStr.Append(txtPicHeigth.Text + "|");            //图片高度
                stringStr.Append(txtPicFrame.Text + "|");             //图片边框
                stringStr.Append(dropisTitle.SelectedValue + "|");    //是否显示标题
                stringStr.Append(txtTitleClass.Text + "|");           //标题样式
                stringStr.Append(txtTitleSize.Text + "|");                  //显示标题字数
                stringStr.Append(dropTarget.SelectedValue + "|");     //链接目标

                foreach (ListItem li in chklExpoAttribute.Items)
                {
                    if (li.Selected)
                    {
                        myValue += "1,";
                    }
                    else
                    {
                        myValue += "0,";
                    }
                }
                if (myValue != "")
                {
                    myValue = myValue.Substring(0, myValue.Length - 1);
                }
                stringStr.Append(myValue);                              //属性显示
                TSystem.Info = stringStr.ToString();

                ISystemLable RSystem = new RSystemLable();
                RSystem.Insert(TSystem);
                ShowMessage("标签添加成功!");
            }
            catch (Exception ex)
            {
                ShowMessage("标签添加失败!");
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
    }
    protected void dropWitchType_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (dropWitchType.SelectedValue == "1")
        {
            trExpoAttribute.Style.Add("display", "block");
        }
        else
        {
            trExpoAttribute.Style.Add("display", "none");
        }
    }
}
