﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using Base;
using Expo;
using nspLable.Manage;

public partial class admin_Lable_Model_Expo_Str : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {

                SystemLableTypeBind();
                TypeidBind();
                Bind();
            }
            else
            {
                SystemLableTypeBind();
                TypeidBind();
            }

        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });

            int i = 0;
            while (i < str.Length)
            {
                dropTypeID.SelectedValue = str[0];
                dropCategory.SelectedValue = str[1];
                txtNum.Text = str[2];
                txtRowsNum.Text = str[3];
                radlDisplayType.SelectedValue = str[4];
                txtTitleSize.Text = str[5];
                txtTitleClass.Text = str[6];
                dropTarget.SelectedValue = str[7];
                radlDisplayTime.SelectedValue = str[8];
                dropDateFormat.SelectedValue = str[9];
                radlExpoAttribute.SelectedValue = str[10];
                dropOrderBy.SelectedValue = str[11];
                break;
            }
           
        }
    }
    /// <summary>
    /// 展会类别
    /// </summary>
    private void TypeidBind()
    {
        IExpoType REx = new RExpoType();
        DataTable dt = REx.GetDataTable();
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataTextField = "Type";
        dropTypeID.DataBind();
        ListItem li = new ListItem("全部", "0");
        dropTypeID.Items.Add(li);
        li.Selected = true;
    }
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null)
        {
            try
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystemLable TSystem = new TSystemLable();
                TSystem.ID = id;
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_Expo_Str";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropTypeID.SelectedValue + "|");     //信息类别
                stringStr.Append(dropCategory.SelectedValue + "|");   //展会分类
                stringStr.Append(txtNum.Text + "|");                  //显示信息条数
                stringStr.Append(txtRowsNum.Text + "|");              //每行显示条数
                stringStr.Append(radlDisplayType.SelectedValue + "|");//显示资讯类别
                stringStr.Append(txtTitleSize.Text + "|");            //显示标题字数
                stringStr.Append(txtTitleClass.Text + "|");           //标题样式
                stringStr.Append(dropTarget.SelectedValue + "|");     //链接目标
                stringStr.Append(radlDisplayTime.SelectedValue + "|");//是否显示日期
                stringStr.Append(dropDateFormat.SelectedValue + "|"); //日期格式
                stringStr.Append(radlExpoAttribute.SelectedValue + "|");//文章类型
                stringStr.Append(dropOrderBy.SelectedValue);           //排序方式
                
                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Update(TSystem);
                ShowMessage("标签修改成功!");
            }
            catch (Exception ex)
            {
                ShowMessage("标签修改失败!");
            }
        }
        else
        {
            try
            {
                TSystemLable TSystem = new TSystemLable();
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_Expo_Str";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropTypeID.SelectedValue + "|");     //信息类别
                stringStr.Append(dropCategory.SelectedValue + "|");   //展会分类
                stringStr.Append(txtNum.Text + "|");                  //显示信息条数
                stringStr.Append(txtRowsNum.Text + "|");              //每行显示条数
                stringStr.Append(radlDisplayType.SelectedValue + "|");//显示资讯类别
                stringStr.Append(txtTitleSize.Text + "|");            //显示标题字数
                stringStr.Append(txtTitleClass.Text + "|");           //标题样式
                stringStr.Append(dropTarget.SelectedValue + "|");     //链接目标
                stringStr.Append(radlDisplayType.SelectedValue + "|");//是否显示日期
                stringStr.Append(dropDateFormat.SelectedValue + "|"); //日期格式
                stringStr.Append(radlExpoAttribute.SelectedValue + "|");//文章类型
                stringStr.Append(dropOrderBy.SelectedValue);           //排序方式
                TSystem.Info = stringStr.ToString();
                
                ISystemLable RSystem = new RSystemLable();
                RSystem.Insert(TSystem);
                ShowMessage("标签添加成功!");
            }
            catch (Exception ex)
            {
                ShowMessage("标签添加失败!");
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
    }
}
