﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using nspLable.Manage;
using System.Text;

public partial class admin_Lable_Model_Industry : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {

                SystemLableTypeBind();
                Bind();
            }
            else
            {
                SystemLableTypeBind();

            }

        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });

            int i = 0;
            while (i < str.Length)
            {
                dropWhicType.SelectedValue = str[0];
                txtBigNum.Text = str[1];
                txtBigClass.Text = str[2];
                txtRowsNum.Text = str[3];
                txtBackColor.Text = str[4];
                dropShowSmall.SelectedValue = str[5];
                txtSmallNum.Text = str[6];
                //txtSmallRowsNum.Text = str[7];
                //txtSmallSize.Text = str[8];
                txtSmallClass.Text = str[9];
                chklOther.SelectedValue = str[10];
                if (str[10]!="")
                {
                    string[] lisNew=str[10].ToString().Split(new char[] { ',' });
                    for(int j=0;j<lisNew.Length;j++)
                    {
                        if (lisNew[j].ToString() == "1")
                        {
                            chklOther.Items[j].Selected = true;
                        }
                    }
                }

                break;
            }

         
        }
    }

    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {

        if (Request.QueryString["ID"] != null)
        {
            try
            {
                string myValue = "";
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystemLable TSystem = new TSystemLable();
                TSystem.ID = id;
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_Industry";
                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropWhicType.SelectedValue + "|");    //行业类别
                stringStr.Append(txtBigNum.Text + "|");              //行业一级显示个数
                stringStr.Append(txtBigClass.Text + "|");              //一级分类样式
                stringStr.Append(txtRowsNum.Text + "|");               //每行显示条数
                stringStr.Append(txtBackColor.Text + "|");             //背景属性 
                stringStr.Append(dropShowSmall.SelectedValue + "|");   //二级分类显示
                stringStr.Append(txtSmallNum.Text + "|");              //二级分类显示个数
                stringStr.Append(10000 + "|");          //二级分类每行显示几条
                stringStr.Append(10000 + "|");             //二级分类显示字数
                stringStr.Append(txtSmallClass.Text + "|");            //二级分类样式
                foreach (ListItem li in chklOther.Items)
                {
                    if (li.Selected)
                    {
                        myValue += "1,";
                    }
                    else
                    {
                        myValue += "0,";
                    }
                }
                if (myValue != "")
                {
                    myValue = myValue.Substring(0, myValue.Length - 1);
                }
                stringStr.Append(myValue);       //分类属性

                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Update(TSystem);
                Messagess.ShowMessage("标签修改成功！");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {
                ShowMessage("标签修改失败!", "Lable/SystemLable/SystemLableManage.aspx");
            }
        }
        else
        {
            try
            {
                string myValue = "";
                TSystemLable TSystem = new TSystemLable();
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_Industry";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropWhicType.SelectedValue + "|");    //行业类别
                stringStr.Append(txtBigNum.Text + "|");              //行业一级显示个数
                stringStr.Append(txtBigClass.Text + "|");              //一级分类样式
                stringStr.Append(txtRowsNum.Text + "|");               //每行显示条数
                stringStr.Append(txtBackColor.Text + "|");             //背景属性 
                stringStr.Append(dropShowSmall.SelectedValue + "|");   //二级分类显示
                stringStr.Append(txtSmallNum.Text + "|");              //二级分类显示个数
                stringStr.Append(10000 + "|");          //二级分类每行显示几条
                stringStr.Append(10000 + "|");             //二级分类显示字数
                stringStr.Append(txtSmallClass.Text + "|");            //二级分类样式
                foreach (ListItem li in chklOther.Items)
                {
                    if (li.Selected)
                    {
                        myValue += "1,";
                    }
                    else
                    {
                        myValue += "0,";
                    }
                }
                if (myValue != "")
                {
                    myValue = myValue.Substring(0,myValue.Length-1);
                }
                stringStr.Append(myValue);       //分类属性
                
                TSystem.Info = stringStr.ToString();

                ISystemLable RSystem = new RSystemLable();
                RSystem.Insert(TSystem);
                Messagess.ShowMessage("标签修改成功！");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {
                ShowMessage("标签添加失败!", "Lable/SystemLable/SystemLableManage.aspx");
            }
        }
    }

    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
    }
}
